/*
 * Copyright (c) 2004 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config;

import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;

// Handlers use this interface (passed to them thorough the IDSHandler.setDSContext(IDSHandlerContext) call)
// to gain read-only acccess to the DS.
public interface IDSHandlerContext
{
    public IDirElement getElement(String elementName) throws DirectoryServiceException;
    public IDirElement[] getElements(Query query) throws DirectoryServiceException;
    public IDirElement[] getAllElements(String dirName) throws DirectoryServiceException;
    public boolean directoryExists(String dirName) throws DirectoryServiceException;
    public IElementIdentity[] listElements(String dirName) throws DirectoryServiceException;
    public IDirIdentity[] listDirectories(String dirName) throws DirectoryServiceException;
    public IIdentity[] listAll(String dirName) throws DirectoryServiceException;
    public void createFSElement(IDirElement element) throws DirectoryServiceException, VersionOutofSyncException;
    public void setElement(IDirElement element) throws DirectoryServiceException, VersionOutofSyncException;
    public String[] getDefinedFolderMetaAttributes() throws DirectoryServiceException;
    public String[] getDefinedElementMetaAttributes() throws DirectoryServiceException;
    public void deleteElement(String elName) throws DirectoryServiceException;
    public void createDirectory(String dirName) throws DirectoryServiceException;
}
