/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config;

import java.util.HashMap;

/**
 * IDeltaAttributeList objects contains the delta between the old and new versions of an IAttributeList object.
 * IDeltaAttributeList objects are typically used by the central repository to upgrade IAttributeList objects that
 * were modified by a utility and by components to obtain up-to-date configuration information. 
 * The central repository performs the following steps to upgrade an IAttributeList object using IDeltaAttributeList
 * information:
 * 1. Use getModifiedItems() to modify items in the list.
 *
 * 2. Use getDeletedItemNumbers() to delete deleted items from the list.
 *
 * 3. Append the getNewItems() vector to the original list.
 *
 * Note that if an insertXXXItem was performed on a IAttributeList then rather then a IDeltaAttributeList
 * a new read-only IAttributeList is used to represent the new IAttributeList object.
 */ 
public interface IDeltaAttributeList
{

 /**
  * Returns the new values (or delta) of modified list items. The key in the returned HashMap object
  * is the ordinal number of the item in the original list. The value is one of: basic type, IDeltaAttributeSet,
  * IDeltaAttributeList, IAttributeSet or IAttributeList.
  *
  * @return A hash table that maps items to their new values (or deltas)
  *
  */
  public HashMap getModifiedItems();

 /**
  * Returns a list of the deleted items as an array of the positions of the items in the original list.
  *
  * @return An array of the positions of the deleted items
  *
  */
  public int[] getDeletedItemNumbers();

 /**
  * Returns a list of the new items appended to the original list.
  * The type of the items is one of: basic type, IAttributeSet or IAttributeList.
  *
  * @return A list of the new items
  *
  */
  public Object[] getNewItems();

}
