/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config;

/**
 * An IDeltaAttributeSet object contains the delta between two versions of an IAttributeSet object.
 */
public interface IDeltaAttributeSet
{
 /**
  * Returns a list of the deleted (or set to null) attributes
  *
  * @return An array of names of the deleted (or set to null) attributes
  *
  */
  public String[] getDeletedAttributesNames();

 /**
  * Returns a list of the modified attributes
  *
  * @return An array of names of the modified attributes
  *
  */
  public String[] getModifiedAttributesNames();

 /**
  * Returns a list of new attributes
  *
  * @return An array of names of new attributes
  *
  */
  public String[] getNewAttributesNames();

 /**
  * Returns the new value (or delta) of an attribute that was added (or modified).
  *
  * @param attributeName the name of the new or modified attribute typically obtained from
  *        a list returned from getModifiedAttributesNames or getNewAttributesNames
  *
  * @return one of the following: basic type, IDeltaAttributeSet, IDeltaAttributeList, IAttributeSet,  IAttributeList
  *          or null (if the attribute was deleted or set to null)
  *
  * @exception NotModifiedAttException if the attribute name was not returned by one of the following methods: getDeletedAttributesNames,
  *            getModifiedAttributesNames or getNewAttributesNames
  *           
  *
  */
  public Object getNewValue(String attributeName) throws NotModifiedAttException;

}
