/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config;

/**
 * An IDeltaElement object contains the delta between two versions of an IElement object.
 */
public interface IDeltaElement extends IBasicElement
{

 /**
  * Returns true if the element was deleted.
  *
  * @return true if the element was deleted.
  *
  */
  public  boolean isDeleted();

 /**
  * Returns the attribute set or the delta attribute set
  *
  * @return the attribute set or the delta attribute set (or null if isDeleted() is true)
  *
  */
  public Object getDeltaAttributes();



}
