/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config;
import java.io.Serializable;

import com.sonicsw.mf.common.config.query.AttributeName;

/**
 * This interface represents a Configuration Element object maintained by the MF directory system.
 * It is typically used as a read-only object by components. Components can, however, create writable
 * copy for their internal use. Each Configuration Element version has a unique
 * identity represented by an IElementIdentity object. The uniqueness of the identity is created by its
 * name, creation timestamp and version number. The IElementIdentity object also contains the element's type
 * and release version. All the information of the IElement
 * object is contained in a single IAttributeSet object. 
 */
public interface IElement extends IBasicElement, Serializable
{

 /**
  * Creates a writable copy of this (writable or read-only) object. 
  * The component can use the clone to have a local modified version of the element.
  *
  * @return the created IElement object
  *
  */
  public IElement createWritableClone();


 /**
  * Returns the attributes of this element.
  *
  * @return the identity object of this IElement.
  *
  */
  public IAttributeSet getAttributes();

 /**
  * Returns the attribute specified.
  *
  * @param attributeName the attribute name (could be nested). Null is illegal.
  * 
  * @return the attribute specified by name
  *
  */
  public Object getAttribute(AttributeName attributeName);

  
 /**
  * Returns true if this element was deleted in the directory service.
  *
  * @return true if this element was deleted in the directory service
  *
  */
  public boolean isDeleted();
    

 /**
  * Returns the archive name of the file represented by this element.
  *
  * @return the archive name of the file represented by this element, null if this element does not represent an archived file.
  *
  */
  public String getArchiveName();

}
