package com.sonicsw.mf.common.config;

/**
 * Contain all the details about the configuration change. IElementChange is passed to the component
 * by the container.
 */
public interface IElementChange
{
    public static final short ELEMENT_ADDED = 0;
    public static final short ELEMENT_UPDATED = 1;
    public static final short ELEMENT_DELETED = 2;
    public static final short ELEMENT_REPLACED = 3; 

    /**
     * Gets the element (or delta to) the configuration that has changed.
     */
    public IBasicElement getElement();

    /**
     * Gets the type of change (add, update or delete).
     *
     * @return see ELEMENT_<> types.
     */
    public short getChangeType();
}
