package com.sonicsw.mf.common.config;

public interface IElementChangeHandler
{
    /**
     * Handler for configuration change information. When a component requests configuration
     * information via its context object it indicates if it wishes to handle changes to
     * that configuration information.
     *
     * @param configurationDelta The object that contains the changes to the original
     *                           configuration information. The configuration to which
     *                           the changes apply can be determined from IDeltaElement.
     *
     * @see com.sonicsw.mf.common.IComponentContext#getConfiguration(boolean)
     * @see com.sonicsw.mf.common.IComponentContext#getConfiguration(String, boolean)
     * @see com.sonicsw.mf.common.IComponentContext#getConfigurations(String)
     */
    public void handleElementChange(IElementChange configurationChange);
}