/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config;

import java.io.Serializable;

/**
 * IElementIdentity provides a unique identification to an IElement version in a single domain name space.
 */
public interface IElementIdentity extends IIdentity, Serializable
{
  public static final long INITIAL_VERSION = 0;

 /**
  * Returns the time at which the element was created in the central repository.
  *
  * @return the difference, measured in milliseconds, between the creation time and midnight, January 1, 1970 UTC.
  *         0 is returned for new elements not yet created in the central repository.
  */
  public long getCreationTimestamp();

 /**
  * Returns the version number of the element. The first version is 1. The version of a new element before
  * it is actually created in the central repository is INITIAL_VERSION (0).
  *
  * @return The version number of the element.
  */
  public long getVersion();


 /**
  * Returns the element's type. The type does not have any meaning for the directory service, it is used and interpreted by the
  * applications (administration applications and components).
  *
  * @return the element's type.
  */
  public String getType();

 /**
  * Returns the element's release version.
  *
  * @return the element's release version
  */
  public String getReleaseVersion();


 /**
  * Returns true if IElementIdentity represents an IElement object with the same name, the same creation timestamp
  * and the same version as this IElementIdentity.
  *
  * @param elementID the identity object we compare to
  *
  * @return true if the IElementIdentity parameter is identical to this IElementIdentity
  */
  public boolean equalVersion(IElementIdentity elementID);

 /**
  * Returns true if IElementIdentity represents an IElement object with the same name and the same creation timestamp
  * this IElementIdentity.
  *
  * @param elementID the identity object we compare to
  *
  * @return true if the IElementIdentity parameter is the same as this IElementIdentity
  */
  public boolean equalEntity(IElementIdentity elementID);
}
