/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config;

/**
 * Represents the identity of directory objects.
 */
public interface IIdentity
{
 /**
  * Returns the full name of the object represented by this IIdentity.
  *
  * @return arrayElemen[0] is the first directory under the root (domain) directory. arrayElement[arrayElement.length-1]
  *         is the base name.
  */
  public String[] getNameComponents();

 /**
  * Returns the full name of the object represented by this IIdentity.
  *
  * @return the full name of the object.
  *
  */
  public String getName();


}
