package com.sonicsw.mf.common.config;

import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;

/**
 * This interface should be implemented by triggers that require logic to be run after a DS transaction is committed.
 * <p>
 * The interface currently extends the IValidator (misnomer) interface to allow configuration and registration to use the 
 * existing DS mechanisms. Post commit trigger methods (afterCreate/afterUpdate/afterDelete) should only be used when during
 * transaction trigger methods (onCreate/onUpdate/onDelete) cannot be used; an example of when post commit methods are
 * appropriate is when modifications are required provided items themselves (vs. related items).
 * <p>
 * Note 1: Trigger implementations should require minimal execution time as they will run on the thread associated with
 * a remote call. If large set of data requires modification from a trigger, it should be queued and executed on another
 * management thread.
 * <p>
 * Note 2: If an afterCreate/afterUpdate updates the element in question, then ITriggerDSContext.setElement(IDeltaElement, false)
 * should be called to do the update otherwise an infinite loop will occur.
 */
public interface IPostCommitTrigger
extends IValidator
{
    public void afterCreate(ITriggerDSContext dsContext, IDirElement[] afterImages) throws DirectoryServiceException;
    
    public void afterUpdate(ITriggerDSContext dsContext, IDirElement[] beforeImages, IDeltaElement[] afterImages) throws DirectoryServiceException;
    
    public void afterDelete(ITriggerDSContext dsContext, IDirElement[] beforeImages) throws DirectoryServiceException;
}
