/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config;

import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;


/**
 * This interface provides Directory Service  read-only access to validation trigger code. 
 */
public interface IValidationDSContext
{

   /**
    * Returns true if this is an XML import transaction
    *
    * @return true if this is an XML import transaction.
    *
    */
   public boolean isImportTransaction();

   /**
    * Returns an element by name.
    *
    * @param elementName the name of the element
    *
    * @return the element object (or null if the element is not in the directory)
    *
    * @exception DirectoryServiceException if there is a problem accessing the underlying storage
    *
    */
    public IElement getElement(String elementName) throws DirectoryServiceException;


   /**
    * Returns the elements that matches the FROM clause and the WHERE clause of the query. Only
    * attributes selected by the SELECT clause are fetched. All the attributes are fetched if the query
    * does not contain a SELECT clause.
    *
    * @param query with a SELECT clause (optional), a FROM clause (mandatory) and a WHERE clause (optional)
    *
    * @return the elements that match the query (can be an empty list)
    *
    * @exception DirectoryServiceException if there is a problem accessing the underlying storage or the parametrs are invalid
    *
    * @see com.sonicsw.mf.common.config.query.Query
    *
    */
    public IElement[] getElements(Query query) throws DirectoryServiceException;
    
    /**
     * Returns the logical name for a storage name.
     * 
     * @param storageName Storage name of an element
     * @return The logical name corresponding to storageName or null if the element doesn't exist in the logical namespace
     * @exception DirectoryServiceException if storageName is a directory or there is a problem mapping the storage name to a logical name
     */
    public String getLogicalName(String storageName) throws DirectoryServiceException;
    
    /**
     * Returns the blob named by the logical name blobName
     * 
     * @param blobName The logical name of the blob in the DS
     * @return The IBlob for blobName, or null if it doesn't exist
     * @exception DirectoryServiceException if there is a problem accessing the blob
     */
    
    public IBlob getFSBlob(String blobName) throws DirectoryServiceException;
}
