/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config;

/**
 * This interface provides configuration change information to IValidator.validate() methods.
 */
public interface IValidationElementChange
extends IElementChange
{
   /**
    * Returns the element before it was modified.
    *
    * @return the element before it was modified. Null is returned if the element is new or if the element is deleted (and recreated)
    *         as a result of XML import.
    *
    */
    public IElement getBeforeImage();
    
   /**
    * Indicates that the element modification should not be validated.
    * Under some circumstances, modifications may not require validation.
    * An example is bulk delete - when deleteElements(directoryName) is called.
    * 
    * @return true if the element modification should be validated, false otherwise.
    * 
    */
    public boolean skipValidation();
}
