/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config;

/**
 * This exception is thrown when an attempt is made to modify a read-only element.
 */
public final class ReadOnlyException extends ConfigException
{
    public ReadOnlyException()
    {
        super("Tried to modify a read only element.");
    }

    public ReadOnlyException(String errorMessage, String objectName)
    {
        super(errorMessage + objectName);
    }

    public ReadOnlyException(String objectName)
    {
        super("Item " + objectName + " is read only.");
    }

}
