/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config;
import java.io.Serializable;

/**
 * A  Reference object contains the name of a Directory Service element
 */
public class Reference implements Serializable
{
  private static final long serialVersionUID = 0L;
  String m_elementName;

 /**
  * Constructs a Reference object which contains an element name.
  *
  * @param elementName the name of the referred element
  *
  */
  public Reference(String elementName)
  {
      m_elementName = elementName;
  }

 /**
  * Returns the name of the referred element.
  *
  * @return the name of the referred element
  *
  */
  public String getElementName()
  {
      return m_elementName;
  }

  @Override
public String toString()
  {
      return m_elementName;
  }

    @Override
    public boolean
    equals(Object obj)
    {
        if (obj == null || this.getClass() != obj.getClass())
        {
            return false;
        }
        return getElementName().equals(((Reference)obj).getElementName());
    }

    @Override
    public int
    hashCode()
    {
        return getElementName().hashCode();
    }

}
