/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeList;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.view.ILogicalNameSpace;

final class DeltaAttributeList implements IDeltaAttributeList, IDelta, java.io.Serializable, ICanReplaceRef
{
  private static final long serialVersionUID = 0L;
  private final static int SERIALIZATION_VERSION = 3;

  private int[] m_deletedArray;
  private HashMap m_deltaVals;
  private Object[] m_newItems;

  DeltaAttributeList(int[] deletedArray,  HashMap deltaVals, Object[] newItems)
  {
      m_deletedArray = deletedArray;
      m_deltaVals = deltaVals;
      m_newItems = newItems;
  }

  public int estimateSize()
  {
      int estimate = Util.ELEMENT_NODE_SIZE;
      if (m_deletedArray != null)
    {
        estimate += (Util.INTEGER_SIZE * m_deletedArray.length);
    }
      if (m_deltaVals != null)
    {
        estimate += Util.estimateHashMapSize(m_deltaVals);
    }
      if (m_newItems != null)
      {
          for (int i = 0; i < m_newItems.length; i++)
        {
            estimate += Util.estimateSize(m_newItems[i]);
        }
      }

      return estimate;
  }

  private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
  {
       s.writeInt(SERIALIZATION_VERSION);
       s.writeObject(m_deletedArray);
       s.writeObject(m_deltaVals);
       s.writeObject(m_newItems);
  }
  private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
  {
      int version = s.readInt();
      if (version != SERIALIZATION_VERSION)
    {
        Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
    }

      m_deletedArray = (int[])s.readObject();
      m_deltaVals = (HashMap)s.readObject();
      m_newItems = (Object[])s.readObject();
  }

  @Override
public boolean replaceReferences(boolean isSystemAtts, IReplaceRef replaceSrvc)
  {
       boolean retVal = true;
       for (int i = 0; i < m_newItems.length; i++)
       {
           Object value = m_newItems[i];
           if (value instanceof ICanReplaceRef)
           {
               boolean ret = ((ICanReplaceRef)value).replaceReferences(false, replaceSrvc);
               if (!ret)
            {
                retVal = false;
            }
           }
           else if (value instanceof Reference)
           {
                Reference newRef = replaceSrvc.replace((Reference)value);
                if (newRef.getElementName().startsWith(ILogicalNameSpace.NO_STORAGE_LABEL))
                {
                    retVal = false;
                }
                m_newItems[i] = newRef;
           }
        else
        {
            continue;
        }
       }

       Set keys = m_deltaVals.keySet();
       Iterator iter = keys.iterator();
       while( iter.hasNext() )
       {
           Object key = iter.next();
           Object value = m_deltaVals.get(key);
           if (value instanceof ICanReplaceRef)
           {
               boolean ret = ((ICanReplaceRef)value).replaceReferences(false, replaceSrvc);
               if (!ret)
            {
                retVal = false;
            }
           }
           else if (value instanceof Reference)
           {
                Reference newRef = replaceSrvc.replace((Reference)value);
                if (newRef.getElementName().startsWith(ILogicalNameSpace.NO_STORAGE_LABEL))
                {
                    retVal = false;
                }
                m_deltaVals.put(key, newRef);
           }
        else
        {
            continue;
        }
       }

       return retVal;

  }

  @Override
public HashMap getModifiedItems()
  {
      return m_deltaVals;
  }

  @Override
public int[] getDeletedItemNumbers()
  {
      return m_deletedArray;
  }

  @Override
public Object[] getNewItems()
  {
      return m_newItems;
  }

    // Translate this delta to an attribute set - USED FOR DEBUGGING ONLY !!!
    // The only usage for this is to be exported to XML! THE STRUCTURE IS NOT CORRECT
    // FOR ANY OTHER USAGE.
    void toAttributeSet(IAttributeSet attributeSet) throws Exception
    {

        attributeSet.setBooleanAttribute("_MF_DELTA_OJECT_IMPL", Boolean.TRUE);
        IAttributeList deletedItems = attributeSet.createAttributeList("DELETED_ITEMS");
        IAttributeList newItems = attributeSet.createAttributeList("NEW_ITEMS");
        IAttributeSet deltaItems = attributeSet.createAttributeSet("DELTA_ITEMS");

        for (int i = 0; i < m_deletedArray.length; i++)
        {
            deletedItems.addIntegerItem(new Integer(m_deletedArray[i]));
        }

        for (int i = 0; i < m_newItems.length; i++)
        {
            ((AttributeList)newItems).addItem(m_newItems[i], false);
        }

        Iterator iterator = m_deltaVals.keySet().iterator();
        while (iterator.hasNext())
        {
           Integer key = (Integer)iterator.next();

           Object value = m_deltaVals.get(key);
           if (value instanceof DeltaAttributeSet)
           {
               IAttributeSet convertedValue = deltaItems.createAttributeSet(key.toString());
               ((DeltaAttributeSet)value).toAttributeSet(convertedValue);
           }
           else if (value instanceof IDeltaAttributeList)
           {
               IAttributeSet convertedValue = deltaItems.createAttributeSet(key.toString());
               ((DeltaAttributeList)value).toAttributeSet(convertedValue);
           }
        else
        {
            ((AttributeSet)deltaItems).setAttributeObject(key.toString(), value, false);
        }

        }
    }


}
