/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.impl;
import com.sonicsw.mf.common.config.IElementIdentity;

public final class ElementIdentity extends Identity implements IElementIdentity, java.io.Serializable
{
  private static final long serialVersionUID = 0L;
  private final static int SERIALIZATION_VERSION = 3;

  private long m_version;
  private long m_creationTime;
  private String m_type;
  private String m_releaseVersion;

  ElementIdentity(long version, long creationTime, String type, String name, String releaseVersion)
  {
      super(name);
      m_version = version;
      m_creationTime = creationTime;
      m_type = type;
      m_releaseVersion = releaseVersion;
  }

  public ElementIdentity(String name, String type, String releaseVersion)
  {
      super(name);
      m_version = IElementIdentity.INITIAL_VERSION;
      m_creationTime = 0;
      m_type = type;
      m_releaseVersion = releaseVersion;
  }

  public ElementIdentity createClone()
  {
      return new ElementIdentity(m_version, m_creationTime, m_type, m_name, m_releaseVersion);
  }

  int estimateSize()
  {
      return Util.OBJECT_SIZE + 8 + 8 /* m_version + m_creationTime */ + Util.estimateSize(m_type) +
             Util.estimateSize(m_releaseVersion);
  }

  private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
  {
       s.writeInt(SERIALIZATION_VERSION);
       s.writeLong(m_version);
       s.writeLong(m_creationTime);
       s.writeObject(m_type);
       s.writeObject(m_releaseVersion);
  }
  private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
  {
      int version = s.readInt();
      if (version != SERIALIZATION_VERSION)
    {
        Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
    }

      m_version = s.readLong();
      m_creationTime = s.readLong();
      m_type = (String)s.readObject();
      m_releaseVersion = (String)s.readObject();

  }


  public void setVersion(long version)
  {
      m_version = version;
  }

  public void setCreationTimestamp(long creationTime)
  {
      m_creationTime = creationTime;
  }

  public void setType(String type, String releaseVersion)
  {
      m_type = type;
      m_releaseVersion = releaseVersion;
  }

  @Override
public long getCreationTimestamp()
  {
      return m_creationTime;
  }

  @Override
public long getVersion()
  {
      return m_version;
  }

  @Override
public String getType()
  {
      return m_type;
  }

  @Override
public String getReleaseVersion()
  {
      return m_releaseVersion;
  }


  @Override
public boolean equalVersion(IElementIdentity elementID)
  {
      return (equalEntity(elementID) && elementID.getVersion() == m_version);
  }

  @Override
public boolean equalEntity(IElementIdentity elementID)
  {
      return (elementID.getName().equals(m_name) && elementID.getCreationTimestamp() == m_creationTime);
  }

  @Override
public String toString()
  {
      return "Element ID {" + m_type + "," + m_releaseVersion + "," + m_name + "," + m_version + "," + m_creationTime + "}";
  }

  @Override
public boolean equals(Object obj)
  {
      if ((obj != null) && (obj instanceof ElementIdentity))
    {
        return equalVersion((IElementIdentity)obj);
    }
      return false;
  }

  @Override
public int hashCode()
  {
      if (m_name == null)
    {
        return 0;
    }
    else
    {
        return m_name.hashCode();
    }
  }

}
