/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.impl;
import java.util.HashMap;

import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IEnvelope;

public final class EnvelopeElement extends Element implements IEnvelope, java.io.Serializable
{
    private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 4;

    private HashMap m_properties;
    private IElement m_envelopedElement;

    @Override
    public int estimateSize()
    {
        return super.estimateSize() + ((Element)m_envelopedElement).estimateSize();
    }

    public EnvelopeElement(IElement element)
    {
        super(((ElementIdentity)element.getIdentity()).createClone());
        m_properties = new HashMap(1,1);
        m_envelopedElement = element;
    }

    @Override
    public IElement getEnvelopedElement()
    {
        return m_envelopedElement;
    }

    @Override
    public String getProperty(String name)
    {
        return (String)m_properties.get(name);
    }

    @Override
    public void setProperty(String name, String value)
    {
        m_properties.put(name, value);
    }

    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         s.writeObject(m_properties);
         s.writeObject(m_envelopedElement);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         m_properties = (HashMap)s.readObject();
         m_envelopedElement = (IElement)s.readObject();
    }


}
