/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.impl;
import com.sonicsw.mf.common.config.AttributeSetTypeException;

// Implemented by all obejcts that can book keep their modification history for creating IDelta objects
interface IDeltaBookKeeper
{
    // Create a delta object for this node
    IDelta createDelta(boolean forSubclassing);

    // Applies the delta to the current state of the object to increment it to the next version
    void applyDelta(IDelta delta) throws AttributeSetTypeException;

    // New objects don't keep delta history - we just use the object itself
    boolean isNew();

    // Eliminate the delta history - isNew() will return true
    void removeDeltaHistory();


}

