/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.IAttributeSet;

public interface IElementCache
{

    // Return the element's attributes from cache or from the DS
    public IAttributeSet getAttributes(Element element);

    // Stores the element's attributes in cache
    public void storeAttributes(Element element);

    // Remove the element's attributes in cache
    public void removeAttributes(String elementName);

    // Used to adjust the size of the cache if the configuration has a value different from the default
    public void adjustSize(int newSize);


}
