/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.impl;
import com.sonicsw.mf.common.config.IIdentity;

public abstract class Identity implements IIdentity, java.io.Serializable
{
  private static final long serialVersionUID = 0L;
  protected String m_name;

  Identity(String name)
  {
      m_name = name;
  }

  private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
  {
       s.writeObject(m_name);
  }
  private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
  {
      m_name = (String)s.readObject();
  }

  @Override
public String[] getNameComponents()
  {
      String [] components = null;
      try {
        EntityName eName = new EntityName(m_name);
        components = eName.getNameComponents();
      }
      catch(com.sonicsw.mf.common.config.ConfigException e) {}
      return components; 
  }

  @Override
public String getName()
  {
      return m_name;
  }

  public String setName(String newName)
  {
      return m_name = newName;
  }


}
