/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.impl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

import com.sonicsw.mf.common.config.INamedPayload;
import com.sonicsw.mf.common.config.NameMapperPathException;


// A building block for various name mapping classes
public final class NameMapper
{
    // Unit test
    public static void main(String[] args) throws Exception
    {
        NameMapper mapper = new NameMapper();
        EntityName E1 = new EntityName("/a1/b1/l1");
        EntityName E2 = new EntityName("/a1/b1/l2");
        EntityName E3 = new EntityName("/a1/b2/l3");
        EntityName oldEr = new EntityName("/a1");
        EntityName newEr = new EntityName("/x1");

        mapper.set(E1, "V1");
        mapper.set(E2, "V2");
        mapper.set(E3, "V3");

        System.out.println(mapper.get(E1));
        System.out.println(mapper.get(E2));
        System.out.println(mapper.get(E3));

        NamedPayLoad[] fullList = mapper.scan(new EntityName("/a1/b1"));
        for (int i = 0; i < fullList.length; i++)
        {
            System.out.println(fullList[i]);
        }

        System.out.println();

        NamedPayLoad[] renamedList = mapper.rename(oldEr, newEr);
        for (int i = 0; i < renamedList.length; i++)
        {
            System.out.println(renamedList[i]);
        }

        System.out.println();
        System.out.println("REMOVE: " + ((INamedPayload[])mapper.remove(new EntityName("/x1/b1/l1")))[0]);
        System.out.println();
        fullList = mapper.scan(new EntityName("/"));
        for (int i = 0; i < fullList.length; i++)
        {
            System.out.println(fullList[i]);
        }

        System.out.println();
        System.out.println("REMOVE: " + ((INamedPayload[])mapper.remove(new EntityName("/x1/b1/l2")))[0]);
        System.out.println();
        fullList = mapper.scan(new EntityName("/"));
        for (int i = 0; i < fullList.length; i++)
        {
            System.out.println(fullList[i]);
        }

        System.out.println();
        System.out.println("REMOVE: " + ((INamedPayload[])mapper.remove(new EntityName("/x1/b2/l3")))[0]);
        System.out.println();
        fullList = mapper.scan(new EntityName("/"));
        for (int i = 0; i < fullList.length; i++)
        {
            System.out.println(fullList[i]);
        }





        System.out.println();
        E1 = new EntityName("/a1/b1/l1");
        E2 = new EntityName("/a1/b1/l2");
        E3 = new EntityName("/a2/b2/l3");


        mapper.set(E1, "V1");
        mapper.set(E2, "V2");
        mapper.set(E3, "V3");

        System.out.println(mapper.get(E1));
        System.out.println(mapper.get(E2));
        System.out.println(mapper.get(E3));

        System.out.println();
        fullList = mapper.scan(new EntityName("/"));
        for (int i = 0; i < fullList.length; i++)
        {
            System.out.println(fullList[i]);
        }

        System.out.println();
        oldEr = new EntityName("/a1/b1/l1");
        newEr = new EntityName("/a1/b1/x1");
        renamedList = mapper.rename(oldEr, newEr);
        for (int i = 0; i < renamedList.length; i++)
        {
            System.out.println("RENAMED: " + renamedList[i]);
        }

        System.out.println();
        renamedList =  mapper.remove(new EntityName("/a1/b1"));
        for (int i = 0; i < renamedList.length; i++)
        {
            System.out.println("REMOVED ITEM: " + renamedList[i]);
        }
        //System.out.println("REMOVE: " + mapper.remove(new EntityName("/a1/b1")));
        System.out.println();
        fullList = mapper.scan(new EntityName("/"));
        for (int i = 0; i < fullList.length; i++)
        {
            System.out.println("NAME: " + fullList[i].getName() + " PAYLOAD: " +  fullList[i].getPayload());
        }



    }

    MapperNode m_root;

    public NameMapper()
    {
        m_root = new MapperNode();
    }

    public void set(EntityName name, Object payLoad)
    {
        getParent(name, true).put(name.getBaseName().toLowerCase(), payLoad);
    }

    public Object get(EntityName name)
    {
        if (name.isRoot())
        {
            return m_root;
        }

        MapperNode parent = getParent(name, false);
        if (parent != null)
        {
            return parent.get(name.getBaseName().toLowerCase());
        }
        else
        {
            return null;
        }
    }

   public Object getPrefix(EntityName name)
    {
        if (name.isRoot())
        {
            return null;
        }

        Object currentNode = m_root;
        String[] nameComponents = name.getNameComponents();
        for (int i = 0; i < nameComponents.length; i++)
        {
            currentNode = ((MapperNode)currentNode).get(nameComponents[i].toLowerCase());

            if (currentNode == null)
            {
                return null;
            }
            else if (!(currentNode instanceof MapperNode))
            {
                return currentNode;
            }
        }

        return null;
    }


    // Returns the removed payloads (or an empty list if does not exist)
    public NamedPayLoad[] remove(EntityName name)
    {
        NamedPayLoad[] result = scan(name);
        removeInternal(name);
        return result;
    }

    private Object removeInternal(EntityName name)
    {
        MapperNode parent = getParent(name, false);
        if (parent == null)
        {
            return null;
        }
        Object result = parent.remove(name.getBaseName().toLowerCase());
        if (parent.isEmpty())
        {
            EntityName parentName = name.getParentEntity();
            if (!parentName.isRoot())
            {
                removeInternal(parentName);
            }
        }
        return result;
    }


    // Returns all the renamed leaves
    public NamedPayLoad[] rename(EntityName oldName, EntityName newName)
    {
        Object renamedObject = removeInternal(oldName);
        if (renamedObject == null)
        {
            return null;
        }
        else
        {
            set(newName, renamedObject);
        }

        return scan(newName);

    }

    public NamedPayLoad[] scan(EntityName nodeName)
    {
        ArrayList<NamedPayLoad> namedPayLoads = new ArrayList<NamedPayLoad>();
        scan(nodeName, get(nodeName), namedPayLoads);
        NamedPayLoad[] result = new NamedPayLoad[namedPayLoads.size()];
        namedPayLoads.toArray(result);
        return result;
    }

    private void scan(EntityName name, Object nodeObject, ArrayList<NamedPayLoad> namedPayLoads)
    {
        if (nodeObject == null)
        {
            return;
        }
        if (!(nodeObject instanceof MapperNode))
        {
            namedPayLoads.add(new NamedPayLoad(name,nodeObject));
        }
        else
        {
            MapperNode node = (MapperNode)nodeObject;
            Iterator<Entry<String, Object>> items = node.entrySet().iterator();
            while (items.hasNext())
            {
                Entry<String, Object> entry = items.next();
                String baseName =  entry.getKey();
                scan(name.createChild(baseName), entry.getValue(), namedPayLoads);
            }
        }

    }

    private MapperNode getParent(EntityName name, boolean ensureExistence)
    {
        String[] parentComponents = name.getParentComponents();
        String triedPath = "";
        MapperNode currentDir = m_root;

        for (int i = 0; i < parentComponents.length; i++)
        {
            Object nextLevel = currentDir.get(parentComponents[i].toLowerCase());
            triedPath = triedPath + "/" + parentComponents[i];
            if (nextLevel != null && !(nextLevel instanceof MapperNode))
            {
                throw new NameMapperPathException(name + " is illegal", triedPath, nextLevel);
            }

            MapperNode nextDir = (MapperNode)nextLevel;

            if (nextDir == null)
            {
                if (ensureExistence)
                {
                    nextDir = new MapperNode();
                    currentDir.put(parentComponents[i].toLowerCase(), nextDir);
                }
                else
                {
                    return null;
                }
            }
            currentDir = nextDir;
        }
        return currentDir;
    }

    public final static class NamedPayLoad implements INamedPayload

    {
        NamedPayLoad(EntityName name, Object payload)
        {
            m_name = name;
            m_payload = payload;
        }

        @Override
        public String toString()
        {
            return m_name + " " + m_payload;
        }

        @Override
        public String getName()
        {
            return m_name.getName();
        }

        @Override
        public Object getPayload()
        {
            return m_payload;
        }

        EntityName m_name;
        Object m_payload;
    }


    // This is need to distinguish bewtween HashMap pay loads and tree nodes
    private final static class MapperNode extends HashMap<String, Object>{}


}
