/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.impl;
import java.util.HashMap;
import java.util.Iterator;

import com.sonicsw.mf.common.config.INextVersionToken;

public final class NextVersionToken implements INextVersionToken, java.io.Serializable
{
    private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 4;
    private HashMap m_ids;

    public NextVersionToken(HashMap ids)
    {
        m_ids = ids;
    }

    // Clone this and replaces all names in IDs to logical names.
    // We clone to prevent any chance that the replacement will side effect
    // internal DS data
    public NextVersionToken replaceReferences(IReplaceRef replaceSrvc)
    {
        HashMap newIds = new HashMap();
        NextVersionToken newToken = new NextVersionToken(newIds);
        Iterator iterator = m_ids.keySet().iterator();
        while (iterator.hasNext())
        {
            String storageName = (String)iterator.next();
            ElementIdentity oldID = (ElementIdentity)m_ids.get(storageName);
            String logicalName = null;
            try
            {
                logicalName = replaceSrvc.replace(storageName);
            }
            catch (Exception e){}

            if (logicalName != null)
            {
                ElementIdentity newID = oldID.createClone();
                newID.setName(logicalName);
                newIds.put(logicalName, newID);
            }

        }

        return newToken;
    }


    // Merge ids with the ids contained by otherToken
    public NextVersionToken(HashMap ids, NextVersionToken otherToken)
    {
        m_ids = ids;

        if (otherToken == null)
        {
            return;
        }

        HashMap otherTable = otherToken.getIdsTable();
        Iterator iterator = otherTable.keySet().iterator();
        while (iterator.hasNext())
        {
            String elementName = (String)iterator.next();
            m_ids.put(elementName, otherTable.get(elementName)); 
        }
    }

    private HashMap getIdsTable()
    {
        return m_ids;
    }

    ElementIdentity getID(String name)
    {
        Object idObject = m_ids.get(name);

        if (idObject == null || (!(idObject instanceof ElementIdentity)))
        {
            throw new IllegalStateException("Invalid token for element \"" + name + "\" was passed to getNextVersion.");
        }
 
        return (ElementIdentity)idObject;
    }


    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         s.writeObject(m_ids);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         m_ids = (HashMap)s.readObject();
    }


}
