/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.impl;
import com.sonicsw.mf.common.config.AttributeSetTypeException;


final class TypedAttSet implements IDictionary, java.io.Serializable
{
    private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 3;

    private Object[]  m_values;
    private AttributeSetType m_type;

    TypedAttSet(AttributeSetType type )
    {
        m_type = type;
        m_values = null;
    }

    @Override
    public int estimateSize()
    {
        int estimate = Util.OBJECT_SIZE + Util.ARRAY_SIZE;

        if (m_values == null)
        {
            return estimate;
        }

        for (int i = 0; i < m_values.length; i++)
        {
            estimate += Util.estimateSize(m_values[i]);
        }
        return estimate;
    }

    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         s.writeObject(m_values);
         s.writeObject(m_type);
    }
    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
        int version = s.readInt();
        if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

        m_values = (Object[])s.readObject();
        m_type = (AttributeSetType)s.readObject();

    }


    private int getIndex(String attName) throws AttributeSetTypeException
    {
        Integer index = (Integer)m_type.get(attName);
        if (index == null)
        {
            throw new AttributeSetTypeException(attName, m_type.getName());
        }
        else
        {
            return index.intValue();
        }
    }

    void setValues(Object[] values)
    {
        m_values = values;
    }

    String getTypeName()
    {
        return m_type.getName();
    }

    @Override
    public int size()
    {
        return m_type.size();
    }

    @Override
    public Object get(String attName) throws AttributeSetTypeException
    {
        return m_values[getIndex(attName)];
    }

    @Override
    public String[] attributes()
    {
        return m_type.getAttributeNames();
    }

    @Override
    public Object[] values()
    {
        return m_values;
    }

    @Override
    public Object put(String attName, Object value) throws AttributeSetTypeException
    {
        int index = getIndex(attName);
        Object oldValue = m_values[index];
        m_values[index] = value;
        return oldValue;
    }

    @Override
    public Object remove(String attName) throws AttributeSetTypeException 
    {
        int index = getIndex(attName);
        Object oldValue = m_values[index];
        m_values[index] = null;
        return oldValue;
    }

    // Tells my type object that I'm deleted
    @Override
    public void delete()
    {
        m_type.removeTypedSet(this);
    }


}
