/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.impl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import com.sonicsw.mf.common.config.AttributeSetTypeException;


final class UntypedAttSet implements IDictionary,  java.io.Serializable
{
    private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 3;

    private HashMap m_table;
    private transient Set m_set;

    UntypedAttSet(String user, byte[] password)
    {
        this();
        try
        {
            if (user != null)
            {
                put(Element.USER_NAME_ATTRIBUTE, user);
            }
            if (password != null)
            {
                put(Element.USER_PASSWORD_ATTRIBUTE, password);
            }
        }
        catch (AttributeSetTypeException e)
        {
            e.printStackTrace();
            throw new Error(e.toString());
        }
    }

    UntypedAttSet()
    {
        m_table = new HashMap();
        m_set =  m_table.keySet();
    }

    @Override
    public int estimateSize()
    {
        return  Util.OBJECT_SIZE + Util.estimateHashMapSize(m_table);
    }


    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         s.writeObject(m_table);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
        int version = s.readInt();
        if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

       m_table = (HashMap)s.readObject();
       m_set =  m_table.keySet();

    }


    @Override
    public int size()
    {
        return m_table.size();
    }

    @Override
    public String[] attributes()
    {
        int count = m_table.size();
        String[] result = new String[count];
        Iterator iterator = m_set.iterator();
        for (int i = 0; i < count; i++)
        {
            result[i] = (String)iterator.next();
        }
        return result;
    }

    @Override
    public Object[] values()
    {
        int count = m_table.size();
        Object[] result = new Object[count];
        Iterator iterator = m_set.iterator();
        for (int i = 0; i < count; i++)
        {
            result[i] = iterator.next();
        }
        return result;
    }

    @Override
    public Object get(String attName)throws AttributeSetTypeException
    {
        return m_table.get(attName);
    }

    @Override
    public Object put(String attName, Object value) throws AttributeSetTypeException
    {
        return m_table.put(attName, value);
    }

    @Override
    public Object remove(String key) throws AttributeSetTypeException 
    {
        return m_table.remove(key);
    }

    //No Resources to release for untyped set
    @Override
    public void delete(){}
}
