package com.sonicsw.mf.common.config.query;

import java.util.HashMap;

import com.sonicsw.mf.common.config.query.impl.Util;
import com.sonicsw.mf.common.dirconfig.IDirElement;

public class AttributeValueComparator extends AbstractElementComparator 
{
	private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 1;
    
	private AttributeName m_attrName = null;
	
	public AttributeValueComparator(AttributeName attrName)
	{
		m_attrName = attrName;
	}

	@Override
    public int compare(IDirElement el1, IDirElement el2) 
	{
		Object attrValue1 = el1.getAttribute(m_attrName);
		Object attrValue2 = el2.getAttribute(m_attrName);
		if (attrValue1 != null)
		{
			if (attrValue2 != null)
             {
                return attrValue1.toString().compareTo(attrValue2.toString()); // for now, we can change
            }
			                                                                   // this later
			return 1;
		}
		else if (attrValue2 != null)
        {
            return -1;
        }
		return 0;
	}
	
	private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         HashMap table = new HashMap(1, 1);
         table.put("AN", m_attrName);
         s.writeObject(table);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         HashMap table = (HashMap)s.readObject();
         m_attrName = (AttributeName)table.get("AN");
    }

}
