/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.query;
import com.sonicsw.mf.common.config.query.impl.Util;

/**
 * All types of boolean expressions extends BooleanExpression
 */
public abstract class BooleanExpression implements java.io.Serializable
{
    private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 3;

    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
        s.writeInt(SERIALIZATION_VERSION);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }
    }



}
