package com.sonicsw.mf.common.config.query;

import java.io.Serializable;
import java.util.HashMap;

import com.sonicsw.mf.common.config.query.impl.Util;

public class ContainsExpression
extends BooleanExpression
implements Serializable, IDualOperandExpression
{
    private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 3;

    private AttributeName m_firstOperand;
    private String m_secondOperand;
    
    public ContainsExpression(AttributeName attribute, String value)
    {
        m_firstOperand = attribute;
        m_secondOperand = value;
    }
    
    @Override
    public Object getFirstOperand()
    {
        return m_firstOperand;
    }

    
    @Override
    public Object getSecondOperand()
    {
        return m_secondOperand;
    }
    
    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         HashMap table = new HashMap(2,1);
         table.put("op1", m_firstOperand);
         table.put("op2", m_secondOperand);
         s.writeObject(table);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         HashMap table = (HashMap)s.readObject();
         m_firstOperand = (AttributeName)table.get("op1");
         m_secondOperand = (String)table.get("op2");
    }

}
