/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.query;
import java.util.HashMap;

import com.sonicsw.mf.common.config.query.impl.Util;

/**
 * Specifies the directory which contains the set of elements the query will process
 */
public final class FromDirectory extends From implements java.io.Serializable
{
    private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 3;

    private String m_dirName;

  /**
    * Constructs a From clause to represent selection from a DS directory.
    *
    * @param dirName the name of the DS directory (null is invalid)
    *
    */
    public FromDirectory(String dirName)
    {
       if (dirName == null)
    {
        throw new NullPointerException();
    }

        m_dirName = dirName;
    }

  /**
    * Returns the name of the directory
    *
    * @return the name of the directory
    *
    */
    public String getDirectoryName()
    {
        return m_dirName;
    }

   /**
    * returns the string representation of this FromDirectory clause.
    *
    * @return the string representation of this FromDirectory clause
    */
    @Override
    public String toString()
    {
        return "DIRECTORY " + m_dirName;
    }

    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         HashMap table = new HashMap(1,1);
         table.put("nm", m_dirName);
         s.writeObject(table);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         HashMap table = (HashMap)s.readObject();
         m_dirName = (String)table.get("nm");
    }


}
