/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.query;
import java.util.HashMap;

import com.sonicsw.mf.common.config.query.impl.Util;

/**
 * Specifies the list of elements the query will process
 */
public final class FromElementList extends From implements java.io.Serializable
{
    private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 3;

    private String[] m_elements;

  /**
    * Constructs a From clause to represent selection from a list of elements.
    *
    * @param elementNames the list of elements to select from (null is invalid)
    *
    */
    public FromElementList(String[] elementNames)
    {
       if (elementNames == null)
    {
        throw new NullPointerException();
    }

        m_elements = elementNames;
    }

  /**
    * Returns the list of elements.
    *
    * @return the list of elements
    *
    */
    public String[] getElementNames()
    {
        return m_elements;
    }

   /**
    * returns the string representation of this FromElementList clause.
    *
    * @return the string representation of this FromElementList clause
    */
    @Override
    public String toString()
    {
        String result = "ELEMENTS ";
        for (int i = 0; i < m_elements.length; i++)
        {
            result += "\n\t" + m_elements[i];
        }

        return result;
    }

    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         HashMap table = new HashMap(1,1);
         table.put("elmnts", m_elements);
         s.writeObject(table);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         HashMap table = (HashMap)s.readObject();
         m_elements = (String[])table.get("elmnts");
    }

}
