/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.query;
import java.util.HashMap;

import com.sonicsw.mf.common.config.query.impl.Util;

/**
 * Specifies the directory which contains the set of elements the query will process
 */
public final class FromElementType extends From implements java.io.Serializable
{
    private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 3;

    private String m_type;

  /**
    * Constructs a From clause to represent selection from a DS directory.
    *
    * @param type the name of the DS directory (null is invalid)
    *
    */
    public FromElementType(String type)
    {
       if (type == null)
    {
        throw new NullPointerException();
    }

        m_type = type;
    }

  /**
    * Returns the name of the directory
    *
    * @return the name of the directory
    *
    */
    public String getType()
    {
        return m_type;
    }

   /**
    * returns the string representation of this FromElementType clause.
    *
    * @return the string representation of this FromElementType clause
    */
    @Override
    public String toString()
    {
        return "TYPE " + m_type;
    }

    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         HashMap table = new HashMap(1,1);
         table.put("tp", m_type);
         s.writeObject(table);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         HashMap table = (HashMap)s.readObject();
         m_type = (String)table.get("tp");
    }


}
