package com.sonicsw.mf.common.config.query;

import java.util.HashMap;

import com.sonicsw.mf.common.config.query.impl.Util;

public class FromFolder extends From implements java.io.Serializable
{

    private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 3;

    private String m_folder;

    public FromFolder(String folder)
    {
       if (folder == null)
    {
        throw new NullPointerException();
    }

        m_folder = folder;
    }

    @Override
    public String toString()
    {
        return "FOLDER " + m_folder;
    }

    public String getFolderName()
    {
        return m_folder;
    }

    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         HashMap table = new HashMap(1,1);
         table.put("nm", m_folder);
         s.writeObject(table);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         HashMap table = (HashMap)s.readObject();
         m_folder = (String)table.get("nm");
    }

}