/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */
package com.sonicsw.mf.common.config.query;

/**
 * Represents 'op1 op op2' expressions.
 */
public interface IDualOperandExpression
{
   /**
    * Returns the first operand of this expression
    *
    * @return the first operand of this expression
    *
    */
    public Object getFirstOperand();

   /**
    * Returns the second operand of this expression
    *
    * @return the second operand of this expression
    *
    */
    public Object getSecondOperand();
}
