/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */
package com.sonicsw.mf.common.config.query;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;

import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.query.impl.Util;

/**
 * Represents 'IAttributeList contains <value>' boolean expression.
 * Currently restricted to:  'IAttributeList contains basic value'
 */
public final class ListContainsExpression extends BooleanExpression implements java.io.Serializable, IDualOperandExpression
{
    private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 3;

    private Object m_op1;
    private Object m_op2;

   /**
    * Constructs an 'list attribute name contains <value>' boolean expression
    *
    * @param name the name of the list. Null is invalid.
    * @param value a String value. Null is valid.
    *
    */
    public ListContainsExpression(AttributeName name, String value)
    {
        this ((Object)name, (Object)value);
    }

   /**
    * Constructs an 'list attribute name contains <value>' boolean expression
    *
    * @param name the name of the list. Null is invalid.
    * @param value an Integer value.  Null is valid.
    *
    */
    public ListContainsExpression(AttributeName name, Integer value)
    {
        this ((Object)name, (Object)value);
    }

   /**
    * Constructs an 'list attribute name contains <value>' boolean expression
    *
    * @param name the name of the list. Null is invalid.
    * @param value a Boolean value.  Null is valid.
    *
    */
    public ListContainsExpression(AttributeName name, Boolean value)
    {
        this ((Object)name, (Object)value);
    }

   /**
    * Constructs an 'list attribute name contains <value>' boolean expression
    *
    * @param name the name of the list. Null is invalid.
    * @param value a byte[] value. Null is valid.
    *
    */
    public ListContainsExpression(AttributeName name, byte[] value)
    {
        this ((Object)name, (Object)value);
    }

   /**
    * Constructs an 'list attribute name contains <value>' boolean expression
    *
    * @param name the name of the list. Null is invalid.
    * @param value a Long value.  Null is valid.
    *
    */
    public ListContainsExpression(AttributeName name, Long value)
    {
        this ((Object)name, (Object)value);
    }


   /**
    * Constructs an 'list attribute name contains <value>' boolean expression
    *
    * @param name the name of the list. Null is invalid.
    * @param value a BigDecimal value.  Null is valid.
    *
    */
    public ListContainsExpression(AttributeName name, BigDecimal value)
    {
        this ((Object)name, (Object)value);
    }

   /**
    * Constructs an 'list attribute name contains <value>' boolean expression
    *
    * @param name the name of the list. Null is invalid.
    * @param value a com.sonicsw.mf.common.config.Reference value.  Null is valid.
    *
    */
    public ListContainsExpression(AttributeName name, Reference value)
    {
        this ((Object)name, (Object)value);
    }


   /**
    * Constructs an 'list attribute name contains <value>' boolean expression
    *
    * @param name the name of the list. Null is invalid.
    * @param value a Date value.  Null is valid.
    *
    */
    public ListContainsExpression(AttributeName name, Date value)
    {

        this ((Object)name, (Object)value);
    }


    private ListContainsExpression(Object op1, Object op2)
    {
        if (op1 == null)
        {
            throw new NullPointerException();
        }

        m_op1 = op1;
        m_op2 = op2;
    }

   /**
    * Returns the AttributeName object of this expression
    *
    * @return the AttributeName object of this expression
    *
    */
    @Override
    public Object getFirstOperand()
    {
        return m_op1;
    }

   /**
    * Returns the value object of this expression
    *
    * @return the value object of this expression
    *
    */
    @Override
    public Object getSecondOperand()
    {
        return m_op2;
    }

   /**
    * returns the string representation of this expression
    *
    * @return the string representation of this expression
    */
    @Override
    public String toString()
    {
        return m_op1 + " = " + m_op2;
    }

    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         HashMap table = new HashMap(2,1);
         table.put("op1", m_op1);
         table.put("op2", m_op2);
         s.writeObject(table);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         HashMap table = (HashMap)s.readObject();
         m_op1 = (Object)table.get("op1");
         m_op2 = (Object)table.get("op2");
    }


}
