/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */
package com.sonicsw.mf.common.config.query;

import java.util.HashMap;

import com.sonicsw.mf.common.config.query.impl.Util;

/**
 * Represents 'attribute-list-item starts with <string-value>' expression.
 */
public final class ListItemStartsWithExpression extends BooleanExpression implements java.io.Serializable, IDualOperandExpression
{
    private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 3;

    private AttributeName m_op1;
    private String m_op2;

   /**
    * Constructs an 'attribute-list-item starts with string-value' boolean expression
    *
    * @param name the name of the list attribute. Null is invalid.
    * @param value a String value. Null is valid.
    *
    */
    public ListItemStartsWithExpression(AttributeName listAttributeName, String value)
    {
        if (listAttributeName  == null)
        {
            throw new NullPointerException();
        }
        
        m_op1 = listAttributeName;
        m_op2 = value;
    }


   /**
    * Returns the AttributeName object of this expression
    *
    * @return the AttributeName object of this expression
    *
    */
    @Override
    public Object getFirstOperand()
    {
        return m_op1;
    }

   /**
    * Returns the value object of this expression
    *
    * @return the value object of this expression
    *
    */
    @Override
    public Object getSecondOperand()
    {
        return m_op2;
    }

   /**
    * returns the string representation of this expression
    *
    * @return the string representation of this expression
    */
    @Override
    public String toString()
    {
        return m_op1 + " item starts with " + m_op2;
    }

    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         HashMap table = new HashMap(2,1);
         table.put("op1", m_op1);
         table.put("op2", m_op2);
         s.writeObject(table);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         HashMap table = (HashMap)s.readObject();
         m_op1 = (AttributeName)table.get("op1");
         m_op2 = (String)table.get("op2");
    }


}
