package com.sonicsw.mf.common.config.query;

import java.util.HashMap;

import com.sonicsw.mf.common.config.query.impl.Util;
import com.sonicsw.mf.common.dirconfig.IDirElement;

public class LogicalNameComparator extends AbstractElementComparator
{
	private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 1;

	@Override
    public int compare(IDirElement el1, IDirElement el2) 
	{
		String el1Name = el1.getIdentity().getName();
		String el2Name = el2.getIdentity().getName();
		return el1Name.compareTo(el2Name);
	}
	
	private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         HashMap table = new HashMap();
         s.writeObject(table);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         HashMap table = (HashMap)s.readObject();
    }

}
