package com.sonicsw.mf.common.config.query;

import java.io.Serializable;
import java.util.HashMap;

import com.sonicsw.mf.common.config.query.impl.Util;
import com.sonicsw.mf.common.dirconfig.IDirElement;

public class OrderedBy implements Serializable 
{
	private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 1;
    
    private ElementComparator<IDirElement> m_comparator;
    
    public OrderedBy(ElementComparator<IDirElement> comp)
    {
    	m_comparator = comp;
    }
    
    public ElementComparator<IDirElement> getComparator()
    {
    	return m_comparator;
    }
    
    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         HashMap table = new HashMap(1, 1);
         table.put("comp", m_comparator);
         s.writeObject(table);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         HashMap table = (HashMap)s.readObject();
         m_comparator = (ElementComparator<IDirElement>)table.get("comp");
    }

}
