package com.sonicsw.mf.common.config.query;

import java.io.Serializable;
import java.util.HashMap;

import com.sonicsw.mf.common.config.query.impl.Util;
import com.sonicsw.mf.common.dirconfig.IDirElement;

/**
 * Implements cookie that gets passed back and forth between DS and client
 * allowing the client to tell the DS which subsets of the data to get.
 * @author davila
 *
 */
public class QueryBatch implements Serializable
{
	private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 1;
    
    private int m_size = 100;
    private int m_firstIndex = -1; 
    private int m_lastIndex = -1; 
    private IDirElement[] m_resultElements = null;

    public int getSize() { return m_size; }
    
    public void setSize(int size) { m_size = size; }
    
    public IDirElement[] getElements()
    {
    	return m_resultElements;
    }
    
    public QueryBatch(IDirElement[] els, QueryBatch existing) // for backward compatibility of API
    {
    	m_resultElements = els;
    	if (existing != null)
    	{
    		m_firstIndex = existing.m_firstIndex;
    		m_lastIndex = existing.m_lastIndex;
    		m_size = existing.m_size;
    	}
    }
    
    public QueryBatch()
    {
    	
    }
    
    public void next(IDirElement[] candidates)
    {
    	IDirElement[] batchResult = null;
    	int newLastIndex;
    	int newFirstIndex;
    	if (m_size >= 0)
    	{
    		newLastIndex = m_lastIndex + (m_size);
        	newFirstIndex = newLastIndex - (m_size - 1);
    	}
    	else
    	{
    		newFirstIndex = m_firstIndex + m_size;
    		newLastIndex = newFirstIndex - (m_size + 1);
    	}
    	if (newFirstIndex >= candidates.length || newLastIndex < 0)
        {
            // nothing left to return; keep all indexes the way they were
    		// and return nothing
    		m_resultElements = new IDirElement[0];
        }
    	m_firstIndex = newFirstIndex < 0 ? 0 : newFirstIndex;
    	m_lastIndex = newLastIndex >= candidates.length ? candidates.length - 1 : newLastIndex;
    	
    	batchResult = new IDirElement[(m_lastIndex - m_firstIndex) + 1];
        System.arraycopy(candidates, m_firstIndex, batchResult, 0, (m_lastIndex - m_firstIndex) + 1); 
        m_resultElements = batchResult;
    }
    
    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         HashMap table = new HashMap(3,1);
         table.put("size", new Integer(m_size));
         table.put("start", new Integer(m_firstIndex));
         table.put("end", new Integer(m_lastIndex));
         table.put("els", m_resultElements);
         s.writeObject(table);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
    	System.out.println("QueryBatch.readObject");
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         HashMap table = (HashMap)s.readObject();
         m_size = ((Integer)table.get("size"));
         m_firstIndex = ((Integer)table.get("start")).intValue();
         m_lastIndex = ((Integer)table.get("end")).intValue();
         m_resultElements = (IDirElement[])table.get("els");
         System.out.println("size, firstIndex, lastIndex " + m_size + " " + m_firstIndex + " " + m_lastIndex);
    }

}
