/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.query;
import java.util.HashMap;

import com.sonicsw.mf.common.config.query.impl.Util;

/**
 * The Select object contains a list of attributes selected for retrieval from a configuration element.
 */
public final class Select implements java.io.Serializable
{
    private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 3;

    AttributeName[] m_attributes;

   /**
    * returns the string representation of this Select object
    *
    * @return the string representation of this Select object
    */
    @Override
    public String toString()
    {
        String result = "";
        for (int i = 0; i < m_attributes.length; i++)
        {
            result += "\n\t" + m_attributes[i];
        }

        return result;

    }

   /**
    * Constructs the list of attributes to be fetched from elements the Where clause evaluated 'true'
    * for. If the list is empty then only the element's IElementIdentity object is fetched. Null is invalid.
    *
    * @param attributes the list of attributes to be fetched
    *
    */
    public Select(AttributeName[] attributes)
    {
        if (attributes == null)
        {
            throw new NullPointerException();
        }

        m_attributes = attributes;
    }

   /**
    * Returns the list of attributes to be fetched.
    *
    * @return the list of attributes to be fetched.
    */
    public AttributeName[] getSelectionList()
    {
         return m_attributes;
    }

    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         HashMap table = new HashMap(1,1);
         table.put("att", m_attributes);
         s.writeObject(table);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         HashMap table = (HashMap)s.readObject();
         m_attributes = (AttributeName[])table.get("att");

    }
    
}
