package com.sonicsw.mf.common.config.query;

import java.util.HashMap;

import com.sonicsw.mf.common.config.query.impl.Util;
import com.sonicsw.mf.common.dirconfig.IDirElement;

public class TypeComparator extends AbstractElementComparator
{
	private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 1;
    
	@Override
    public int compare(IDirElement el1, IDirElement el2) 
	{
		String el1Type = el1.getIdentity().getType();
		String el2Type = el2.getIdentity().getType();
		return el1Type.compareTo(el2Type);
	}
	
	private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         HashMap table = new HashMap();
         s.writeObject(table);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         HashMap table = (HashMap)s.readObject();
    }

}
