/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.query;
import java.util.HashMap;

import com.sonicsw.mf.common.config.query.impl.Util;

/**
 * The Where object represents criteria for selecting a subset of elements from a larger set 
 * described in a From object. Currently only a chain of AND boolean expressions is supported.
 */
public final class Where implements java.io.Serializable
{
    private static final long serialVersionUID = 0L;
    private final static int SERIALIZATION_VERSION = 3;

    BooleanExpression[] m_andChain;

   /**
    * returns the string representation of this Where clause.
    *
    * @return the string representation of this Where clause
    */
    @Override
    public String toString()
    {
        String result = "";
        for (int i = 0; i < m_andChain.length; i++)
        {
            result += "\n\t" + m_andChain[i];

            if (i + 1 < m_andChain.length)
            {
                result += " AND";
            }
        }

        return result;
    }

   /**
    * Constructs a chain of AND boolean expressions to evaluate candidate elements from the From clause.
    * If andChain is empty then all the elements are evaluated 'true' for fetching. Null is invalid.
    *
    * @param attributes the list of attributes to be fetched
    *
    */
    public Where (BooleanExpression[] andChain)
    {
        if (andChain == null)
        {
            throw new NullPointerException();
        }

        m_andChain = andChain;
    }

   /**
    * Returns the chain of AND boolean expressions.
    *
    * @return the chain of AND boolean expressions.
    *
    */
    public BooleanExpression[] getAndChain()
    {
        return m_andChain;
    }

    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
         s.writeInt(SERIALIZATION_VERSION);
         HashMap table = new HashMap(1,1);
         table.put("ch", m_andChain);
         s.writeObject(table);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException
    {
         int version = s.readInt();
         if (version != SERIALIZATION_VERSION)
        {
            Util.throwSerialVersionMismatch(version, SERIALIZATION_VERSION);
        }

         HashMap table = (HashMap)s.readObject();
         m_andChain = (BooleanExpression[])table.get("ch");
    }


}
