
/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.query.impl;
import java.util.ArrayList;

import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.IReplaceRef;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.BooleanExpression;
import com.sonicsw.mf.common.config.query.EqualExpression;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromElementList;
import com.sonicsw.mf.common.config.query.IDualOperandExpression;
import com.sonicsw.mf.common.config.query.ListContainsExpression;
import com.sonicsw.mf.common.config.query.NotEqualExpression;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.query.Where;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;


public final class ReferenceReplacer
{
   public static Query replaceReferences(Query query,  IReplaceRef replacer)
   {
       return new Query().setSelect(query.getSelect()).setFrom(repRef(query.getFrom(),replacer)).setWhere(repRef(query.getWhere(),replacer));
   }

   private static From repRef(From oldFrom, IReplaceRef replacer)
   {
       if (oldFrom == null)
    {
        return null;
    }

       if (oldFrom instanceof FromElementList)
       {
           String[] oldNames = ((FromElementList)oldFrom).getElementNames();
           ArrayList newNames = new ArrayList();

           for (int i = 0; i < oldNames.length; i++)
         {
            try
               {
                   newNames.add(replacer.replace(oldNames[i]));
               }
               catch (VersionOutofSyncException e){} // Just ignore element names that have no storage name
        }

           String[] result = new String[newNames.size()];
           newNames.toArray(result);

           return new FromElementList(result);
         
       }
    else
    {
        return oldFrom;
    }
   }

  private static Where repRef(Where oldWhere, IReplaceRef replacer)
   {
       if (oldWhere == null)
    {
        return null;
    }

       BooleanExpression[] oldAndChain = oldWhere.getAndChain();
       BooleanExpression[] newAndChain = new BooleanExpression[oldAndChain.length];

       for (int i = 0; i < oldAndChain.length; i++)
       {
           IDualOperandExpression dualExpression = null;
           AttributeName attName = null;
           Reference newRef  = null;

           if (oldAndChain[i] instanceof IDualOperandExpression)
        {
            dualExpression = (IDualOperandExpression)oldAndChain[i];
        }

           if (dualExpression != null)
           {
               attName = (AttributeName)dualExpression.getFirstOperand();
               Object value = dualExpression.getSecondOperand();
               if (value instanceof Reference)
            {
                newRef =  replacer.replace((Reference)value);
            }
           }

           if (oldAndChain[i] instanceof EqualExpression && newRef != null )
        {
            newAndChain[i] = new EqualExpression(attName, newRef);
        }
        else if (oldAndChain[i] instanceof ListContainsExpression && newRef != null)
        {
            newAndChain[i] = new ListContainsExpression(attName, newRef);
        }
        else if (oldAndChain[i] instanceof NotEqualExpression && newRef != null)
        {
            newAndChain[i] = new NotEqualExpression(attName, newRef);
        }
        else
        {
            newAndChain[i] = oldAndChain[i];
        }
       }

       return new Where(newAndChain);
   }

}
