
/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config.query.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.VersionMisMatchException;
import com.sonicsw.mf.common.config.query.AttributeName;


public final class Util
{

   public static void throwSerialVersionMismatch(int objectVersion, int classVersion) throws java.io.IOException
   {
       throw new java.io.IOException("Serialization version mismatch. Serialized object version: " + objectVersion +
                                     " class version: " + classVersion);
   }

   public static AttributeName removeFirstComponent(AttributeName name)
   {
       int count = name.getComponentCount();

       if (count == 0)
    {
        return null;
    }

       AttributeName result = new AttributeName();

       for (int i = 1; i < count; i++)
       {
           Object component = name.getComponent(i);
           if (component instanceof java.lang.String)
        {
            result.setNextComponent((String)component);
        }
        else
        {
            result.setNextComponent(((Integer)component).intValue());
        }
       }

       return result;
   }

   public static void getReferenceChanges(IElement currentElement, IDeltaElement delta,
                                          ArrayList addedRefs, ArrayList modifiedRefs, ArrayList deletedRefs)
   throws VersionMisMatchException
   {
        // Create temporary updated element.
        IElement updatedElement = currentElement.createWritableClone();
        ((Element)updatedElement).doApplyDelta(delta);

        // Determine references in current element.
        ArrayList currentRefList = new ArrayList();
        findReferences(currentElement, currentRefList);

        // Determine references in updated element.
        ArrayList updatedRefList = new ArrayList();
        findReferences(updatedElement, updatedRefList);

        // Determine Deleted and Modified References
        Iterator it = currentRefList.iterator();
        while (it.hasNext())
        {
            AttributeName currentRefAttr = (AttributeName) it.next();
            if (updatedRefList.contains(currentRefAttr))
            {   // Reference still exists in updated element.
                // Determine if reference value has changed
                if (!updatedElement.getAttribute(currentRefAttr).equals(currentElement.getAttribute(currentRefAttr)))
                {   // Reference has changed.
                    modifiedRefs.add(currentRefAttr);
                }
            }
            else
            {   // Reference has been deleted from updated element.
                deletedRefs.add(currentRefAttr);
            }
        }

        // Determine New References
        it = updatedRefList.iterator();
        while (it.hasNext())
        {
            AttributeName updatedRefAttr = (AttributeName) it.next();
            if (!currentRefList.contains(updatedRefAttr))
            {   // Reference is only in updated element therefore new.
                addedRefs.add(updatedRefAttr);
            }
        }
   }

   public static void findReferences(IElement element, ArrayList matchList)
   {
       findReferences(element.getAttributes(), matchList,
                              new AttributeName(element.getIdentity().getName(), true));
   }

   public static void findReferences(IAttributeSet attSet, ArrayList matchList,
                                             AttributeName myName)
   {

       HashMap map = attSet.getAttributes();
       Set keys = map.keySet();
       Iterator iter = keys.iterator();
       while( iter.hasNext() )
       {
           String key = (String)iter.next();
           Object value = map.get(key);
           if (value instanceof IAttributeSet)
        {
            findReferences((IAttributeSet)value, matchList,
                                      myName.createClone().setNextComponent(key));
        }
        else if (value instanceof IAttributeList)
        {
            findReferences((IAttributeList)value, matchList,
                                      myName.createClone().setNextComponent(key));
        }
        else if (value instanceof Reference)
        {
            matchList.add(myName.createClone().setNextComponent(key));
        }
        else
        {
            continue;
        }
       }

   }

   public static void findReferences(IAttributeList attList, ArrayList matchList,
                                             AttributeName myName)
   {
       for (int i = 0; i < attList.getCount(); i++)
       {
           Object value = attList.getItem(i);
           if (value instanceof IAttributeSet)
        {
            findReferences((IAttributeSet)value, matchList,
                                      myName.createClone().setNextComponent(i));
        }
        else if (value instanceof IAttributeList)
        {
            findReferences((IAttributeList)value, matchList,
                                      myName.createClone().setNextComponent(i));
        }
        else if (value instanceof Reference)
        {
            matchList.add(myName.createClone().setNextComponent(i));
        }
        else
        {
            continue;
        }
       }
   }

   public static void findMatchingReferences(IElement element, Reference reference, ArrayList matchList)
   {
       findMatchingReferences(element.getAttributes(), reference, matchList,
                              new AttributeName(element.getIdentity().getName(), true));
   }

   public static void findMatchingReferences(IAttributeSet attSet, Reference reference, ArrayList matchList,
                                             AttributeName myName)
   {

       HashMap map = attSet.getAttributes();
       Set keys = map.keySet();
       Iterator iter = keys.iterator();
       while( iter.hasNext() )
       {
           String key = (String)iter.next();
           Object value = map.get(key);
           if (value instanceof IAttributeSet)
        {
            findMatchingReferences((IAttributeSet)value, reference, matchList,
                                      myName.createClone().setNextComponent(key));
        }
        else if (value instanceof IAttributeList)
        {
            findMatchingReferences((IAttributeList)value, reference, matchList,
                                      myName.createClone().setNextComponent(key));
        }
        else if ((value instanceof Reference) &&
                    ((Reference)value).getElementName().equals(reference.getElementName()))
        {
            matchList.add(myName.createClone().setNextComponent(key));
        }
        else
        {
            continue;
        }
       }

   }
   public static void findMatchingReferences(IAttributeList attList, Reference reference, ArrayList matchList,
                                             AttributeName myName)
   {
       for (int i = 0; i < attList.getCount(); i++)
       {
           Object value = attList.getItem(i);
           if (value instanceof IAttributeSet)
        {
            findMatchingReferences((IAttributeSet)value, reference, matchList,
                                      myName.createClone().setNextComponent(i));
        }
        else if (value instanceof IAttributeList)
        {
            findMatchingReferences((IAttributeList)value, reference, matchList,
                                      myName.createClone().setNextComponent(i));
        }
        else if ((value instanceof Reference) &&
                    ((Reference)value).getElementName().equals(reference.getElementName()))
        {
            matchList.add(myName.createClone().setNextComponent(i));
        }
        else
        {
            continue;
        }
       }
   }
}
