package com.sonicsw.mf.common.config.upgrade;

import java.util.HashMap;
import java.util.Set;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IMFDirectories;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromDirectory;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;

public class DomainManager implements IMigrationProcess
{ 
	UpgradeEnv m_upgradeEnv;
	
	public String upgrade(UpgradeEnv env)
	    throws Exception
	{
		m_upgradeEnv = env;
		performVersionedUpgrade((String)env.getProp(DSVERSIONPROP));
		// do generic upgrade for all versions
		fixDomainPoliciesAndCollections();
		fix_MFLibrary();
		upgradeDomainElement();
		// right now this returns null, it really should be aggregating the
		// results of calling the versioned upgrades in performVersionedUpgrade...
		return null;
	}
	
	public void preConnectUpgrade(UpgradeEnv env) throws Exception
	{
		m_upgradeEnv = env;
		performVersionedPreConnectUpgrade((String)env.getProp(DSVERSIONPROP));
		// nothing to do generically for all versions
	}
	
	void fixDomainPoliciesAndCollections() 
	    throws Exception
    {
        if (m_upgradeEnv.isDEBUG())
        {
            System.out.println("ConfigUpgrade.fixDomainPoliciesAndCollections");
        }
        m_upgradeEnv.m_curTransaction = m_upgradeEnv.dsFileSystem.createTransaction();
        try
        {
            Query query = new Query();
            From typeFrom = new FromElementType("MF_AUTHENTICATION_DOMAIN");
            query.setFrom(typeFrom);
            IDirElement[] els = m_upgradeEnv.dsFileSystem.getFSElements(query, false);
            for (int domainIndex = 0; domainIndex < els.length; domainIndex++)
            {
                // domains are complex configurations, so their product version is found at a
                // different level in the view
                String elementName = els[domainIndex].getIdentity().getName();
                if (m_upgradeEnv.isDEBUG())
                {
                    System.out.println("ConfigUpgrade.fixDomain...., domain logical name == " + elementName);
                }
                String nameStripped = elementName.substring(0, elementName.lastIndexOf("/"));
                m_upgradeEnv.getUtils().fixProductAndReleaseVersion(nameStripped, "/_MFDomainDescriptor");
                try
                {
                	m_upgradeEnv.dsAdmin.setElementReleaseVersion(m_upgradeEnv.dsFileSystem.logicalToStorage(nameStripped) + "/_MFRefreshTime", CURRENT_RELEASE_VERSION);
                }
                catch (Exception e)
                {
                } // this will fail if the _MFRefreshTime is not there. I found that for 6.0 installs
                String storageName = m_upgradeEnv.dsFileSystem.logicalToStorage(elementName);
                String usersDirectory = storageName.substring(0, storageName.lastIndexOf("/") + 1) + "_MFUsers";
                query = new Query();
                typeFrom = new FromDirectory(usersDirectory);
                query.setFrom(typeFrom);
                IDirElement[] users = m_upgradeEnv.dsAdmin.getElements(query, false);
                for (int usersIndex = 0; usersIndex < users.length; usersIndex++)
                {
                	m_upgradeEnv.dsAdmin.setElementReleaseVersion(users[usersIndex].getIdentity().getName(), CURRENT_RELEASE_VERSION);
                }
                String groupsDirectory = storageName.substring(0, storageName.lastIndexOf("/") + 1) + "_MFGroups";
                query = new Query();
                typeFrom = new FromDirectory(groupsDirectory);
                query.setFrom(typeFrom);
                IDirElement[] groups = m_upgradeEnv.dsAdmin.getElements(query, false);
                for (int groupIndex = 0; groupIndex < groups.length; groupIndex++)
                {
                	m_upgradeEnv.dsAdmin.setElementReleaseVersion(groups[groupIndex].getIdentity().getName(), CURRENT_RELEASE_VERSION);
                }
            }

            // policies
            typeFrom = new FromElementType("MQ_AUTHORIZATION_POLICY");
            query.setFrom(typeFrom);
            els = m_upgradeEnv.dsFileSystem.getFSElements(query, false);
            for (int policyIndex = 0; policyIndex < els.length; policyIndex++)
            {
                // policies are complex configurations, so their product version is found at a
                // different level in the view
                String elementName = els[policyIndex].getIdentity().getName();
                String nameStripped = elementName.substring(0, elementName.lastIndexOf(IMFDirectories.MF_DIR_SEPARATOR));
                m_upgradeEnv.getUtils().fixProductAndReleaseVersion(nameStripped, "/_MQPolicyDescriptor");

                String storageName = m_upgradeEnv.dsFileSystem.logicalToStorage(elementName);
                String aclsDirectory = storageName.substring(0, storageName.lastIndexOf("/") + 1) + "_MQACLs";
                query = new Query();
                typeFrom = new FromDirectory(aclsDirectory);
                query.setFrom(typeFrom);
                IDirElement[] acls = m_upgradeEnv.dsAdmin.getElements(query, false);
                for (int aclsIndex = 0; aclsIndex < acls.length; aclsIndex++)
                {
                	m_upgradeEnv.dsAdmin.setElementReleaseVersion(acls[aclsIndex].getIdentity().getName(), CURRENT_RELEASE_VERSION);
                }
                String qopsDirectory = storageName.substring(0, storageName.lastIndexOf("/") + 1) + "_MQQoPs";
                query = new Query();
                typeFrom = new FromDirectory(qopsDirectory);
                query.setFrom(typeFrom);
                IDirElement[] qops = m_upgradeEnv.dsAdmin.getElements(query, false);
                for (int qopsIndex = 0; qopsIndex < qops.length; qopsIndex++)
                {
                	m_upgradeEnv.dsAdmin.setElementReleaseVersion(qops[qopsIndex].getIdentity().getName(), CURRENT_RELEASE_VERSION);
                }

            }
            // auth SPIs
            typeFrom = new FromElementType("MF_AUTHENTICATION_SPI");
            query.setFrom(typeFrom);
            try
            {
                els = m_upgradeEnv.dsFileSystem.getFSElements(query, false);
                for (int spiIndex = 0; spiIndex < els.length; spiIndex++)
                {
                    m_upgradeEnv.getUtils().fixProductAndReleaseVersion(els[spiIndex].getIdentity().getName());
                }
            }
            catch (Exception e)
            {
            } // if there's no SPIs, there's no directory for them, so we get an exception here

            // mgmt SPIs
            typeFrom = new FromElementType("MF_MANAGEMENT_SPI");
            query.setFrom(typeFrom);
            try
            {
                els = m_upgradeEnv.dsFileSystem.getFSElements(query, false);
                for (int spiIndex = 0; spiIndex < els.length; spiIndex++)
                {
                    m_upgradeEnv.getUtils().fixProductAndReleaseVersion(els[spiIndex].getIdentity().getName());
                }
            }
            catch (Exception e)
            {
            } // if there's no SPIs, there's no directory for them, so we get an exception here
            // container collections
            typeFrom = new FromElementType("MF_CONTAINER_COLLECTION");
            query.setFrom(typeFrom);
            els = m_upgradeEnv.dsFileSystem.getFSElements(query, false);
            for (int containerIndex = 0; containerIndex < els.length; containerIndex++)
            {
                m_upgradeEnv.getUtils().fixProductAndReleaseVersion(els[containerIndex].getIdentity().getName());
            }
            // component collections
            typeFrom = new FromElementType("MF_COMPONENT_COLLECTION");
            query.setFrom(typeFrom);
            els = m_upgradeEnv.dsFileSystem.getFSElements(query, false);
            for (int componentIndex = 0; componentIndex < els.length; componentIndex++)
            {
                m_upgradeEnv.getUtils().fixProductAndReleaseVersion(els[componentIndex].getIdentity().getName());
            }
            if (m_upgradeEnv.isDEBUG())
            {
                System.out.println("ConfigUpgrade.fixDomainPoliciesAndCollections committing transaction");
            }
            m_upgradeEnv.dsFileSystem.executeTransaction(m_upgradeEnv.m_curTransaction);
        }
        finally
        {
            if (m_upgradeEnv.isDEBUG())
            {
                System.out.println("ConfigUpgrade.fixDomainPoliciesAndCollections setting m_curTransaction to null");
            }
            m_upgradeEnv.m_curTransaction = null;
        }

    }
	
	private void fix_MFLibrary()
	    throws ConfigException, VersionOutofSyncException, DirectoryServiceException
	{
		if (m_upgradeEnv.isDEBUG())
        {
            System.out.println("DomainManager.fix_MFLibary");
        }
		// Latest MQ validator
		IDirElement mqValidator = ElementFactory.createElement("/_MFLibrary/validators/MQ_100_" + CURRENT_PRODUCT_VERSION, "MF_VALIDATOR", "100");
        IAttributeSet topSet = mqValidator.getAttributes();
        topSet.setStringAttribute("VALIDATION_CLASS", "com.sonicsw.mq.dstriggers.DeleteTrigger");
        topSet.setStringAttribute("RELEASE_VERSION", CURRENT_RELEASE_VERSION);
        IAttributeList archives = topSet.createAttributeList("VALIDATOR_ARCHIVES");
        archives.addStringItem("sonicfs:///System/DS/validators/MQ/" + CURRENT_PRODUCT_VERSION + "/MQtriggers.jar");
        m_upgradeEnv.dsAdmin.setElement(mqValidator.doneUpdate(), null);
        
        // Latest MF validator. Assumes the previous /_MFLibrary/validators/MF_100_3.1 has been deleted by the versioned
        // DomainManager classes. The name of the validator remains the same, but the version attributes of the 
        // element change
        IDirElement mfValidator = ElementFactory.createElement("/_MFLibrary/validators/MF_100_3.1", "MF_VALIDATOR", "100");
        topSet = mfValidator.getAttributes();
        topSet.setStringAttribute("VALIDATION_CLASS", "com.sonicsw.mf.dstriggers.DeleteTrigger");
        topSet.setStringAttribute("RELEASE_VERSION", CURRENT_RELEASE_VERSION);
        archives = topSet.createAttributeList("VALIDATOR_ARCHIVES");
        archives.addStringItem("sonicfs:///System/DS/validators/MF/" + CURRENT_PRODUCT_VERSION + "/MFtriggers.jar");
        m_upgradeEnv.dsAdmin.setElement(mfValidator.doneUpdate(), null);
        
        // ************ MQ plugins start **************************  
        // MQ - remove versions not supported anymore
        Set<String> deleteProductVersions = PRODUCT_VERSIONS_SUPPORTED_BY_EARLIEST_UPGRADE_VERSION.keySet();
        for (String version : deleteProductVersions)
        {
        	String versionNoDots = getVersionWithNoDots(version);
        	String releaseVersion = PRODUCT_VERSIONS_SUPPORTED_BY_EARLIEST_UPGRADE_VERSION.get(version);
        	m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/plugins/MQ_ROOT_" + releaseVersion + "_" + versionNoDots, null);
        	IDirElement mqFileElement = m_upgradeEnv.dsFileSystem.getFSElement("/System/SMC/Plugins/pluginMQ" + versionNoDots + ".jar", true);
            if (mqFileElement != null) 
            {
            	m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)mqFileElement.doneUpdate());
            	m_upgradeEnv.dsFileSystem.deleteFSElement("/System/SMC/Plugins/pluginMQ" + versionNoDots + ".jar");
            }

            //Removing un-supported MF delete trigger entries from the DS
            m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/validators/MF_100_" + version, null);
        }
      
        // MQ - supported versions
        for (String version : SUPPORTED_PRODUCT_VERSIONS.keySet())
        {
        	String versionNoDots = getVersionWithNoDots(version);
        	String releaseVersion = SUPPORTED_PRODUCT_VERSIONS.get(version);
        	IDirElement plugin = m_upgradeEnv.dsAdmin.getElement("/_MFLibrary/plugins/MQ_ROOT_" + releaseVersion + "_" + versionNoDots, false);
        	if (plugin == null) 
            {
    			plugin = ElementFactory.createElement("/_MFLibrary/plugins/MQ_ROOT_" + releaseVersion + "_" + versionNoDots.replace("_",""), "MF_PLUGIN", "100");
    			topSet = plugin.getAttributes();
    			topSet.setStringAttribute("CONFIG_PLUGIN_FACTORY_CLASS", "com.sonicsw.mq.gui.config.MQPluginFactory");
    			topSet.setStringAttribute("RUNTIME_PLUGIN_FACTORY_CLASS", "com.sonicsw.mq.gui.runtime.MQPluginFactory");
    			topSet.setStringAttribute("PLUGIN_FACTORY_CLASSPATH", "sonicfs:///System/SMC/Plugins/pluginMQ" + versionNoDots + ".jar");
    			createMQPluginAttributes(topSet);
    			m_upgradeEnv.dsAdmin.setElement(plugin.doneUpdate(), null);
    		}
        }
        
        // MQ - latest plugin
        String currentVersionNoDots = getVersionWithNoDots(CURRENT_PRODUCT_VERSION);
        IDirElement plugin = ElementFactory.createElement("/_MFLibrary/plugins/MQ_ROOT_" + CURRENT_RELEASE_VERSION + "_" + currentVersionNoDots.replace("_",""), "MF_PLUGIN", "100");
	    topSet = plugin.getAttributes();
	    topSet.setStringAttribute("CONFIG_PLUGIN_FACTORY_CLASS", "com.sonicsw.mq.gui.config.MQPluginFactory");
	    topSet.setStringAttribute("RUNTIME_PLUGIN_FACTORY_CLASS", "com.sonicsw.mq.gui.runtime.MQPluginFactory");
	    topSet.setStringAttribute("PLUGIN_FACTORY_CLASSPATH", "sonicfs:///System/SMC/Plugins/pluginMQ" + currentVersionNoDots + ".jar");
	    createMQPluginAttributes(topSet);
	    m_upgradeEnv.dsAdmin.setElement(plugin.doneUpdate(), null);
	    
        // ************************  MF plugins start ***************
		// MF - remove unused plugins
	    Set<String> MFDeleteProductVersions = MF_PRODUCT_VERSIONS_SUPPORTED_BY_EARLIEST_UPGRADE_VERSION.keySet();
	    for (String version : MFDeleteProductVersions)
        {
	    	String versionNoDots = getVersionWithNoDots(version);
        	String releaseVersion = MF_PRODUCT_VERSIONS_SUPPORTED_BY_EARLIEST_UPGRADE_VERSION.get(version);
        	m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/plugins/MF_ROOT_" + releaseVersion + "_" + versionNoDots, null);
        	IDirElement mfFileElement = m_upgradeEnv.dsFileSystem.getFSElement("/System/SMC/Plugins/pluginMF" + versionNoDots + ".jar", true);
            if (mfFileElement != null) 
            {
            	m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)mfFileElement.doneUpdate());
            	m_upgradeEnv.dsFileSystem.deleteFSElement("/System/SMC/Plugins/pluginMF" + versionNoDots + ".jar");
            }
            //Removing un-supported MQ delete trigger entries from the DS
            m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/validators/MQ_100_" + version, null);
        }
	    	    
        // MF - supported plugins
	    
	    for (String version : SUPPORTED_PRODUCT_VERSIONS.keySet())
        {
	    	String versionNoDots = getVersionWithNoDots(version);
        	String releaseVersion = SUPPORTED_PRODUCT_VERSIONS.get(version);
        	IDirElement MFPlugin = m_upgradeEnv.dsAdmin.getElement("/_MFLibrary/plugins/MF_ROOT_" + releaseVersion + "_" + versionNoDots, false);
        	if (plugin == null) 
            {
    			plugin = ElementFactory.createElement("/_MFLibrary/plugins/MF_ROOT_" + releaseVersion + "_" + versionNoDots.replace("_","") , "MF_PLUGIN", "100");
    			topSet = plugin.getAttributes();
    			topSet.setStringAttribute("CONFIG_PLUGIN_FACTORY_CLASS", "com.sonicsw.mf.gui.config.MFPluginFactory");
    			topSet.setStringAttribute("RUNTIME_PLUGIN_FACTORY_CLASS", "com.sonicsw.mf.gui.runtime.MFPluginFactory");
    			topSet.setStringAttribute("PLUGIN_FACTORY_CLASSPATH", "sonicfs:///System/SMC/Plugins/pluginMF" + versionNoDots + ".jar");
    			m_upgradeEnv.dsAdmin.setElement(plugin.doneUpdate(), null);
    		}
        }
        
        // MF - latest plugin
	    
	    plugin = ElementFactory.createElement("/_MFLibrary/plugins/MF_ROOT_" + CURRENT_RELEASE_VERSION + "_" + currentVersionNoDots.replace("_","") , "MF_PLUGIN", "100");
	    topSet = plugin.getAttributes();
	    topSet.setStringAttribute("CONFIG_PLUGIN_FACTORY_CLASS", "com.sonicsw.mf.gui.config.MFPluginFactory");
	    topSet.setStringAttribute("RUNTIME_PLUGIN_FACTORY_CLASS", "com.sonicsw.mf.gui.runtime.MFPluginFactory");
	    topSet.setStringAttribute("PLUGIN_FACTORY_CLASSPATH", "sonicfs:///System/SMC/Plugins/pluginMF" + currentVersionNoDots + ".jar");
	    m_upgradeEnv.dsAdmin.setElement(plugin.doneUpdate(), null);
        
        
        //***************** MA PLUGIN START **************************
        //Delete all security plugins and create just 8.5, as only one version of
        // security is supported
        IDirElement secFileElement = null;
        
        HashMap<String, String> MADeleteVersions = new HashMap<String, String>(MF_PRODUCT_VERSIONS_SUPPORTED_BY_EARLIEST_UPGRADE_VERSION);
        MADeleteVersions.putAll(SUPPORTED_PRODUCT_VERSIONS);
        
        for (String version : MADeleteVersions.keySet())
        {
        	String versionNoDots = getVersionWithNoDots(version);
        	String releaseVersion = MADeleteVersions.get(version);
        	m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/plugins/SECURITY_ROOT_" + releaseVersion + "_" + versionNoDots, null);
            secFileElement = m_upgradeEnv.dsFileSystem.getFSElement("/System/SMC/Plugins/pluginSecurity" + versionNoDots + ".jar", true);
            if (secFileElement != null)
            {
                m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)secFileElement.doneUpdate());
                m_upgradeEnv.dsFileSystem.deleteFSElement("/System/SMC/Plugins/pluginSecurity" + versionNoDots + ".jar");
            }
        }
   
        // add the latest security plugin
        plugin = ElementFactory.createElement("/_MFLibrary/plugins/SECURITY_ROOT_" + CURRENT_RELEASE_VERSION + "_" + currentVersionNoDots.replace("_","") , "MF_PLUGIN", "100");
        topSet = plugin.getAttributes();
        topSet.setStringAttribute("CONFIG_PLUGIN_FACTORY_CLASS", "com.sonicsw.security.gui.config.SecurityPluginFactory");
        topSet.setStringAttribute("PLUGIN_FACTORY_CLASSPATH",  "sonicfs:///System/SMC/Plugins/pluginSecurity" + currentVersionNoDots + ".jar");
        m_upgradeEnv.dsAdmin.setElement(plugin.doneUpdate(), null);
        
        // logger plugin
        // remove all old plugins; all the versions are now in the plugin
        // which is part of the MF plugin file.
        // This code includes handling of version for which no logger plugin existed, however
        // 1- deleteElement is a noop if the element does not exist
        // 2 - We check whether loggerFileElement exists before proceeding.
        // REMOVE: remove this code once the lowest version in SUPPORTED_PRODUCT_VERSIONS is 8.5, since that was the version
        // when the logger plugin was incorporated into the MF plugin
        HashMap<String, String> loggerDeleteVersions = new HashMap<String, String>(PRODUCT_VERSIONS_SUPPORTED_BY_EARLIEST_UPGRADE_VERSION);
        loggerDeleteVersions.putAll(SUPPORTED_PRODUCT_VERSIONS);
        
        for (String version : loggerDeleteVersions.keySet())
        {
        	String versionNoDots = getVersionWithNoDots(version);
        	String releaseVersion = loggerDeleteVersions.get(version);
        	m_upgradeEnv.dsAdmin.deleteElement("/_MFLibrary/plugins/LOGGER_ROOT_" + releaseVersion + "_" + versionNoDots, null);
            IDirElement loggerFileElement = m_upgradeEnv.dsFileSystem.getFSElement("/System/SMC/Plugins/pluginLogger" + versionNoDots + ".jar", true);
            if (loggerFileElement != null)
            {
                m_upgradeEnv.dsFileSystem.detachFSBlob((IDeltaDirElement)loggerFileElement.doneUpdate());
                m_upgradeEnv.dsFileSystem.deleteFSElement("/System/SMC/Plugins/pluginLogger" + versionNoDots + ".jar");
            }
        }
	
        HashMap metaAttributes = m_upgradeEnv.dsFileSystem.getMetaAttributes("/Security/Default Certificate Store");
        if (metaAttributes != null)
        {
        	m_upgradeEnv.dsAdmin.setElementReleaseVersion(m_upgradeEnv.dsFileSystem.logicalToStorage("/Security/Default Certificate Store"), CURRENT_RELEASE_VERSION);
            metaAttributes.put("TOOL_ATTRIBUTES", "TYPE=MQ_CERTIFICATES_STORE;CONFIG_VERSION=" + CURRENT_RELEASE_VERSION + ";PRODUCT_VERSION=" + CURRENT_PRODUCT_VERSION);
            m_upgradeEnv.dsFileSystem.setMetaAttributes("/Security/Default Certificate Store", metaAttributes);
       }  
	
	}

    /**
     * Method to return version string without dots.
     * eg. 8.6 as 86 and 10.0 as 10_0
     * @param versionString
     * @return
     */
    private String getVersionWithNoDots(String versionString)
    {
        final int dotLocation = versionString.indexOf(".");
        StringBuilder stringWithNoDots = new StringBuilder(versionString.substring(0,dotLocation));

        //This if condition can be removed in future release when all the old and new version
        // have two digit as major version.
        //In that case just retain the true part with the string building with "_".
        if(dotLocation > 1)
        {
            return stringWithNoDots.append("_").append(versionString.charAt(dotLocation+1)).toString();
        }
        else
        {
            return stringWithNoDots.append(versionString.charAt(dotLocation+1)).toString();
        }
    }

    private void performVersionedUpgrade(String releaseVersion) throws Exception
    {
    	IVersionedDomainManagerUpgrade previousUpgrade = UpgradeRegistry.getConfigDomainUpgrade(releaseVersion);
    	if (previousUpgrade == null)
        {
            throw new Exception("Unable to find a domain manager upgrade method for version " + releaseVersion);
        }
    	previousUpgrade.upgrade(m_upgradeEnv);
    	if (!previousUpgrade.getUpgradedReleaseVersion().equals(CURRENT_RELEASE_VERSION))
        {
            performVersionedUpgrade(previousUpgrade.getUpgradedReleaseVersion());
        }
    }
    
    private void performVersionedPreConnectUpgrade(String releaseVersion) throws Exception
    {
    	IVersionedDomainManagerUpgrade previousUpgrade = UpgradeRegistry.getConfigDomainUpgrade(releaseVersion);
    	if (previousUpgrade == null)
        {
            throw new Exception("Unable to find a domain manager pre-connect upgrade method for version " + releaseVersion);
        }
    	if (m_upgradeEnv.isDEBUG())
        {
            System.out.println("DomainManager.performVersionedPreConnectUpgrade calling " + previousUpgrade );
        }
    	previousUpgrade.preConnectUpgrade(m_upgradeEnv);
    	if (!previousUpgrade.getUpgradedReleaseVersion().equals(CURRENT_RELEASE_VERSION))
        {
            performVersionedPreConnectUpgrade(previousUpgrade.getUpgradedReleaseVersion());
        }
    }
    
    private void upgradeDomainElement() throws Exception
    {
    	m_upgradeEnv.m_utils.fixProductAndReleaseVersion("/_Default");
    }
    
    private void createMQPluginAttributes(IAttributeSet topSet) throws ConfigException, ReadOnlyException
    {
    	IAttributeList http_inbound = topSet.createAttributeList("HTTP_INBOUND");
	    http_inbound.addStringItem("com.sonicsw.mq.gui.config.acceptors.protocols.DirectProtocolConfigFactory");
	    http_inbound.addStringItem("com.sonicsw.mq.gui.config.acceptors.protocols.SOAPProtocolConfigFactory");
	    http_inbound.addStringItem("com.sonicsw.mq.gui.config.acceptors.protocols.JMSProtocolConfigFactory");
	    IAttributeList http_outbound = topSet.createAttributeList("HTTP_OUTBOUND");
	    http_outbound.addStringItem("com.sonicsw.mq.gui.config.routes.DirectRouteConfigFactory");
	    http_outbound.addStringItem("com.sonicsw.mq.gui.config.routes.SoapRouteConfigFactory");
	    http_outbound.addStringItem("com.sonicsw.mq.gui.config.routes.JMSRouteConfigFactory");
	    http_outbound.addStringItem("com.sonicsw.mq.gui.config.routes.WSRouteConfigFactory");
    }
}
