package com.sonicsw.mf.common.config.upgrade;

import java.io.File;
import java.util.HashMap;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IMFDirectories;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.view.ILogicalNameSpace;

public class DomainManager75 extends VersionedDomainManager implements IVersionedDomainManagerUpgrade, IMigrationProcess
{
static String SERVICE_TYPE_FOLDER = "/System/SonicESB/properties/servicetypes";
    
    static String[] INSTALL_SERVICE_TYPE_FILES = new String[]{ "AsynchServiceType",
   	 "BPELServiceType",
   	 "BPEType",
   	 "CBRType",
   	 "DatabaseServiceType",
   	 "DropService",
   	 "PickupService",
   	 "PrototypeService",
   	 "SOAPUnwrapComponentType",
   	 "SplitJoinForEach",
   	 "SplitJoinParallel",
   	 "SplitterService",
   	 "TerminateStepServiceType",
   	 "VerificationServiceType",
   	 "WMQJMSListener",
   	 "WMQJMSSender",
   	 "WSInvocationComponentType",
   	 "XFORMType",
   	 "XMLServiceType"};
	
	
	@Override
    public String upgrade(UpgradeEnv env)
	    throws Exception
	{
		String result = super.upgrade(env);
		deleteFTFiles();
		createDomainElement();
		// the logical link for the domain element was added in the 7.5-7.6 upgrade
		// however it was added incorrectly. So, to fix domains upgraded to 7.6
		// that ended up with no logical domain element, we fix it in the 7.6-8.0 upgrade, 
		// and took it out of the 7.5-7.6 upgrade.
		// addDomainElLogical();
		copyServiceTypes();
		return result;
	}
	
	@Override
    public String getUpgradedReleaseVersion()
	{
		return "103";
	}
	
	@Override
    public String getProductVersion()
	{
		return "7.5";
	}
	
	
	private void deleteFTFiles()
    {
		String hostDir = (String)m_upgradeEnv.getProp(DSHOSTPROP);
		
        boolean deleted = false;
        String separator = System.getProperty("file.separator");
        File hostDirFile = new File(hostDir);
     
        File primary = new File(hostDirFile + separator + m_upgradeEnv.dsAdmin.getDomain() + separator + "primary");
        if (m_upgradeEnv.isDEBUG())
        {
            System.out.println("DomainManager75.deleteFTFiles primary file == "+ primary.toString());
        }
        if (primary.exists())
        {
            if (m_upgradeEnv.isDEBUG())
            {
                System.out.println("DomainManager75.deleteFTFiles primary exists");
            }
            deleted = primary.delete();
            if (!deleted && m_upgradeEnv.isDEBUG())
            {
                System.out.println("DomainManager75.deleteFTFiles primary file was not deleted");
            }
        }
        File backup = new File(hostDirFile + separator + m_upgradeEnv.dsAdmin.getDomain() + separator + "backup");
        if (backup.exists())
        {
            backup.delete();
        }
    }
	
	private void createDomainElement() throws DirectoryServiceException, ConfigException
    {
   	 /*
   	  * /<ConfigElement>
        <ElementID name="/domain/domain" type="MF_DOMAIN" version="1" creationTimestamp="1022171764184" releaseVersion="103"/>
        <AttributeSet>
          <Attribute name="AUDIT_CONFIGURE_EVENTS" type="boolean" value="false"/>
          <Attribute name="AUDIT_MANAGE_EVENTS" type="boolean" value="false"/>
          <Attribute name="ENABLE_CENTRALIZED_AUDIT" type="boolean" value="false"/>
	  <Attribute name="DEFAULT_MANAGEMENT_AUDIT_CONFIG" type="string" value="sonicfs:///Security/DefaultAuditDestinations.xml"/>
          <Attribute name="FORCE_CENTRALIZED_LOGGING" type="boolean" value="false"/>
          <Attribute name="CENTRALIZED_LOG_FILE" type="string" value="./Domain1.log"/>
          <Attribute name="LOG_FILE_SIZE_THRESHOLD" type="long" value="33554432"/>
          <Attribute name="LOG_FILE_ROLLOVER_SIZE_THRESHOLD" type="long" value="4194304"/>
        </AttributeSet>
      </ConfigElement>
   	  */
   	 try
   	 {
   		m_upgradeEnv.dsAdmin.createDirectory("/domain");
   	 }
   	 catch (DirectoryServiceException e) {} //ok, the directory exists already
   	 IDirElement domainElement = m_upgradeEnv.dsAdmin.getElement("/domain/domain", true);
   	 if (domainElement == null) 
   	 {
   		 domainElement = ElementFactory.createElement("/domain/domain", "MF_DOMAIN", "103");
   		 // we'll let all the values default according to the schema in 7.6
   	 }
   	 IAttributeSet topSet = domainElement.getAttributes();
   	 if (topSet.getAttribute("DEFAULT_MANAGEMENT_AUDIT_CONFIG") == null)
    {
        topSet.setStringAttribute("DEFAULT_MANAGEMENT_AUDIT_CONFIG", "sonicfs:///Security/DefaultAuditDestinations.xml");
    }
   	 Reference authDomainRef = (Reference)topSet.getAttribute("AUTHENTICATION_DOMAIN");
   	 if (authDomainRef != null && authDomainRef.getElementName().length() == 0)
    {
        topSet.deleteAttribute("AUTHENTICATION_DOMAIN");
    }
   	m_upgradeEnv.dsAdmin.setElement(domainElement.doneUpdate(), null);
    }
	
//	 the mapping of this element to the logical view as /_Default is done with all
    // other updates to the view element in addDomainElLogical
    
 // copies servicetypes into the new folder structure which started in 7.6
	// A single version of a domain could support files from several versions of ESB
	// so this is why this method deals with all the supported versions, like
	// the plugins code.
	void copyServiceTypes() throws DirectoryServiceException
    {
   	    HashMap[] serviceTypes75 = null;
   	    HashMap[] serviceTypes70 = null;
   	    try
   	    {
   		    serviceTypes75 = m_upgradeEnv.dsFileSystem.listFSAll("/System/SonicESB/7.5/properties/servicetypes");
   	    }
   	    catch (DirectoryServiceException dirE) {}//the folder will not exist if this is just
   	                                          //an MQ install and no ESB
   	    try
	    {
		    serviceTypes70 = m_upgradeEnv.dsFileSystem.listFSAll("/System/SonicESB/7.0/properties/servicetypes");
	    }
	    catch (DirectoryServiceException dirE) {}
   	    if ((serviceTypes75 != null && serviceTypes75.length > 0) || (serviceTypes70 != null && serviceTypes70.length > 0)) 
   	    {
   	    	m_upgradeEnv.dsFileSystem.createFolder("/System", true);
   	    	m_upgradeEnv.dsFileSystem.createFolder("/System/SonicESB", true);
   	    	m_upgradeEnv.dsFileSystem.createFolder("/System/SonicESB/properties", true);
   	    	m_upgradeEnv.dsFileSystem.createFolder("/System/SonicESB/properties/servicetypes", true);
   	    }
   	    if (serviceTypes75 != null)
        {
            copyServiceTypesHelper(serviceTypes75);
        }
   	    if (serviceTypes70 != null)
        {
            copyServiceTypesHelper(serviceTypes70);
        }

    } 
	
	void copyServiceTypesHelper(HashMap[] serviceTypes) throws DirectoryServiceException
    {
		for (int i = 0; i < serviceTypes.length; i++) 
		{
			boolean isInstallFile = false;
			HashMap elMap = serviceTypes[i];
			IElementIdentity elID = (IElementIdentity) elMap.get(ILogicalNameSpace.ELEMENT_IDENTITY);
			String elName = elID.getName();
			String fileName = elName.substring(elName.lastIndexOf(IMFDirectories.MF_DIR_SEPARATOR) + 1);
			String fileNameBase = fileName.substring(0, fileName.lastIndexOf("."));
			if (m_upgradeEnv.isDEBUG())
            {
                System.out.println("ConfigUpgrade.copyServiceTypesHelper examines base " + fileNameBase);
            }
			for (int j = 0; j < INSTALL_SERVICE_TYPE_FILES.length; j++) 
			{
				if (fileNameBase.equals(INSTALL_SERVICE_TYPE_FILES[j])
						|| fileNameBase.equals(INSTALL_SERVICE_TYPE_FILES[j]
								+ "24x24")) 
				{
					isInstallFile = true;
					if (m_upgradeEnv.isDEBUG())
                    {
                        System.out.println("ConfigUpgrade.copyServiceTypesHelper: It is an install file");
                    }
					break;
				}
			}
			if (!isInstallFile) 
			{
				
				String cloneFileID = SERVICE_TYPE_FOLDER + IMFDirectories.MF_DIR_SEPARATOR + fileName;
				if (m_upgradeEnv.dsFileSystem.getFSElement(cloneFileID, false) == null)
				{
					m_upgradeEnv.dsFileSystem.cloneFSBlob(elName, cloneFileID);
				    HashMap metaAttributes = m_upgradeEnv.dsFileSystem.getMetaAttributes(cloneFileID);
				    if (metaAttributes == null)
                    {
                        metaAttributes = new HashMap();
                    }
		         
		            metaAttributes.put("TOOL_ATTRIBUTES", "TYPE=MF_FILE");
		            m_upgradeEnv.dsFileSystem.setMetaAttributes(cloneFileID, metaAttributes);
		            if (m_upgradeEnv.isDEBUG())
                    {
                        System.out.println("ConfigUpgrade.copyServiceTypesHelper: It is not an install file, so copying " + elName + " to " + cloneFileID);
                    }
				}
		         
				if (m_upgradeEnv.isDEBUG())
                {
                    System.out.println("ConfigUpgrade.copyServiceTypesHelper: It is not an install file, bu not copying because it has already been copied " + cloneFileID);
                }
			}
		}
	}
}
