package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.dirconfig.IDirElement;

public class DomainManager76 extends VersionedDomainManager implements IVersionedDomainManagerUpgrade 
{
	@Override
    public String getUpgradedReleaseVersion() 
	{
		return "104";
	}
	
	@Override
    public String getProductVersion()
	{
		return "7.6";
	}

	@Override
    public void preConnectUpgrade(UpgradeEnv env) throws Exception 
	{

	}

	@Override
    public String upgrade(UpgradeEnv env) throws Exception 
	{
		String result = super.upgrade(env);
		// the logical link for the domain element was added in the 7.5-7.6 upgrade
		// however it was added incorrectly. So, to fix domains upgraded to 7.6-8.0
		// that ended up with no logical domain element, we fix it here, and took it out
		// of the 7.5-7.6 upgrade.
		addDomainElLogical();
		return result;
	}
	
	private void addDomainElLogical() throws Exception
    {
   	 /*
   	  * <AttributeSet>
             <AttributeName name="_default"/>  
             <Attribute name="_MFLinkObject" type="string" value="/domain/domain"/>
             <Attribute name="_MFType" type="integer" value="1"/>
             <Attribute name="ORIGINAL_NAME" type="string" value="_Default"/>
             <AttributeList>
               <AttributeName name="_MFAttributesValues"/>
               <ListItem type="string" value="CONFIG_VERSION=104;TYPE=MF_DOMAIN;PRODUCT_VERSION=8.0">
               </ListItem>
             </AttributeList>
           </AttributeSet>
   	  */
    	if (m_upgradeEnv.isDEBUG())
        {
            System.out.println("DomainManager76.addDomainElLogical");
        }
   	    IDirElement viewEl = m_upgradeEnv.dsAdmin.getElement("/_MFSchema/view", true);
   	    IAttributeSet topSet = viewEl.getAttributes();
   	    IAttributeSet rootSet = (IAttributeSet)topSet.getAttribute("_MFRootFolder");
   	    // create the logical /_Default in the view
   	    if (rootSet.getAttribute("_default") == null)
   	    {
			IAttributeSet domainSet = rootSet.createAttributeSet("_default");
			domainSet.setStringAttribute("_MFLinkObject", "/domain/domain");
			domainSet.setIntegerAttribute("_MFType", new Integer(1));
			domainSet.setStringAttribute("ORIGINAL_NAME", "_Default");
			IAttributeList toolAttrs = domainSet.createAttributeList("_MFAttributesValues");
			toolAttrs.addStringItem("CONFIG_VERSION=104;TYPE=MF_DOMAIN;PRODUCT_VERSION=8.0");

			m_upgradeEnv.dsAdmin.setElement(viewEl.doneUpdate(), null);
			/*
			 * IView viewEl = m_upgradeEnv.dsAdmin.getView();
			 * viewEl.link("/Default", "/domain/domain", false);
			 * m_upgradeEnv.dsAdmin.setView(viewEl.doneUpdate());
			 */
			if (m_upgradeEnv.isDEBUG())
            {
                System.out.println("DomainManager76.addDomainElLogical saved view element");
            }
			// we've just added a link in the view, which gets stored but
			// doesn't
			// update the logical namespace. Close the DS and reopen to continue
			// to
			// use the updated logical namespace
			m_upgradeEnv.dsService.closeDS();
			m_upgradeEnv.connectToNewPSEDirectoryService();
   	    }
    }
}
