package com.sonicsw.mf.common.config.upgrade;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import com.sonicsw.mf.mgmtapi.config.constants.IDirectoryServiceConstants;

/*
 *  This file contains version constants that drive the upgrade. Search for REMOVE: tags in the code
 *  for special cases that require changes in other classes
 */
public interface IMigrationProcess 
{
	public static final String CURRENT_RELEASE_VERSION = "107";
	public static final String CURRENT_PRODUCT_VERSION = "10.0";
	// FIRST_CIUPGRADE_RELEASE_VERSION will not change. 
	public static final String FIRST_CIPGRADE_RELEASE_VERSION = "104";
	public static final String OLDEST_UPGRADABLE_VERSION="104";
	public static Map<String,String> SUPPORTED_PRODUCT_VERSIONS = 
        Collections.unmodifiableMap(
                
                new HashMap<String, String>() {
                    {
                        put("8.0", "104");
                        put("8.5", "105");
                        put("8.6", "106");
                    }

                });
	
	public static Map<String,String> PRODUCT_VERSIONS_SUPPORTED_BY_EARLIEST_UPGRADE_VERSION = 
        Collections.unmodifiableMap(
                new HashMap<String, String>() {
                    {
                        put("6.1", "100");
                        put("7.0", "101");
                        put("7.5", "102");
                        put("7.6", "103");
                    }

                });
	
	// REMOVE: This constant should disappear once the oldest supported version does not support either of these in the domain
	public static Map<String,String> MF_PRODUCT_VERSIONS_SUPPORTED_BY_EARLIEST_UPGRADE_VERSION = 
        Collections.unmodifiableMap(
                new HashMap<String, String>() {
                    {
                        put("2.1", "100");
                        put("3.0", "101");
                        put("7.5", "102");
                        put("7.6", "103");
                    }

                });

	
	public static final int REQUEST_TIMEOUT_DEFAULT = 60;    //seconds
	
	public static byte[] NEWLINEBYTES = System.getProperty("line.separator").getBytes();
    public static String URLPROP = "ds.url";
    public static String USERNAMEPROP = "ds.username";
    public static String PASSWORDPROP = "ds.password";      //NOSONAR field change is not required.
    public static String NODEPROP = "connection_node";
    public static String RTPROP = "request.timeout";
    public static String DOMAINPROP = "ds.domain";
    public static String CONNPROPSPROP = "connection.system.properties";
    
    public static String BROKERCNPROP = "sonic.mq.controlNumber";
    public static String LOGGERCNPROP = "event.monitor.controlNumber";
    // as written out in product.properties
    public static String ESBCNPROP = "sonic.esb.controlNumber";
    // as required by the ESB seeder during install
    public static String ESBCNFORSEEDERPROP = "esb.controlNumber";
    public static String WBCNPROP = "workbench.controlNumber";
    public static String ROOTLISTPROP = "root.list";
    
    public static String UPGRADELISTPROP = "upgrade.list";
    public static String TEMPLATELISTPROP = "template.list";
    
    public static String BOOTFILEPWDPROP = "boot.file.password";
    public static String CENTRALURLPROP = "central.connection.url";
    public static String CENTRALUSERPROP = "central.connection.username";
    public static String CENTRALPWPROP = "central.connection.password";
    public static String CENTRALRTPROP = "central.connection.request.timeout";
    public static String CENTRALCTPROP = "central.connection.connect.timeout";
    public static String CENTRALSCPROP = "central.connection.socket.connect";
    public static String CENTRALLBPROP = "central.connection.load.balancing";
    public static String CENTRALCONNPROPSPROP = "central.connection.system.properties";
    public static String CONTLOGPROP = "log.dir";
    public static String CACHEPROP = "cache.dir";
    public static String DBACTIONPROP = "db.action";
    public static String MQSTOREPROP = "mqstore.db.connect";
    public static String LOGFILEPROP = "recovery.log.file";
    public static String WSERVICEPROP = "windows.service.name";
    public static String SSLCERTDIRPROP = "ssl.certificates.dir";
    public static String SSLCERTCHAINPROP = "ssl.certificate.chain";
    public static String WDPROP = "previous.working.directory";
    public static String HOSTDIRPROP = "host.directory";
    public static String COMPONENTSPROP = "components";
    
    public static String DEBUGPROP = "migrate.debug";
    
    public static String CONTAINERSDIRPLACEHOLDER = "<containersDir>";
    public static String MIGRATIONTEMPDIR = "MigrationTemp";
    public static String CONTAINERSDEFAULT = ".";
    public static String DEFAULTDOMAIN = IDirectoryServiceConstants.DOMAIN_NAME_DEFAULT;
    public static String DEFAULTUSER = "Administrator";
    public static String CONTAINERURLPROP = "container.connectionURLs";
    public static String CONTAINERUSERPROP = "container.defaultUser";
    public static String CONTAINERPWDPROP = "container.defaultPassword";
    public static String FILESEPARATOR = File.separator;
    public static String MGMTCONNURLSPROP = "mgmt.connection.urls";
    public static String LAUNCH_SCRIPT = "launchcontainer.bat";
    public static String SHUTDOWN_SCRIPT = "shutdowncontainer.bat";
    public static String INSTALL_PROGRAM_GROUP ="sonic.install.programGroup";
    public static String SONICSW_PROPERTIES = "sonicsw.properties";
    public static String LAUNCH_VERBIAGE = "Start Domain Manager";
    public static String SHUTDOWN_VERBIAGE = "Stop Domain Manager";
    public static String SONICMQDIR = "MQ" + CURRENT_PRODUCT_VERSION;
    public static String MQCONTAINER_ICON_LOCATION = "bin/mq_container.ico";
    public static String WB_INSTALLED_PROP = "sonic.wb.installed";
	public static String ECLIPSE_CHOICE_PROP = "sonic.iw." + CURRENT_PRODUCT_VERSION + ".eclipse.choice";
   
    
    // ***********************  COMPUTED PROPERTY NAMES. 
    
    public static String MQSTORESRCPROP = "mqstore.db.connect.src";
    public static String LOGFILESRCPROP = "recovery.log.file.src";
    public static String DSHOSTSRCPROP = "host.directory.src";
    public static String DSHOSTPROP = "ds.working.dir";
    public static String NEWWDPROP = "working.directory";
    public static String DSVERSIONPROP = "ds.release.version";
    public static String CONTAINERNAMEPROP = "container.name"; // this property changes as different containers are upgraded
    public static String DMELEMENTPROP = "domain.manager.name";
    public static String DSELEMENTPROP = "ds.element.name";
    public static String DMDSELEMENTPROP = "dm.ds.element";
    public static String RESTARTCONTAINERSPROP = "restart.containers";
    public static String BACKUPDSCONTAINERPROP = "backup.ds.container";
    public static String WSNAMEPROP = "WINDOWS_SERVICE_NAME"; // what ContainerSetup wants to see
    public static String BROKERPATHPROP = "broker.path";
    public static String SECONDARYURLSPROP = "SECONDARY_ConnectionURLs";
    
    public static String SHAREDHOSTDIRPROP = "SHARED_HOST_DIRECTORY";
    public static String FTSTATEPROP = "FaultTolerantState";
    public static String ALLOWFAILOVER70PROP = "ALLOW_UPDATES_ON_FAILOVER";
    public static String SEEDDEVBPELPROP = "seed.dev.bpel";
    public static String SAVEDWBLOCATIONPROP = "saved.wb.location";
}