package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.common.dirconfig.IDirElement;

/** 
* The configuration upgrade for a product version. Each method name
* has the configuration type it upgrades as part of the name. The
* ConfigUpgradeDriver calls the implementation of this interface 
* which performs generic upgrades (ConfigUpgrade). The generic upgrade
* in turn calls the implementation of this interface for previous 
* versions. For each release then, typically there's one more 
* implementor of this class defined - 7.6 specific for 7.6.1 or 8.0,
* for instance, and the generic upgrade class is modified to call 
* the new implementation of this interface. Older implementations
* can be retired, as their use is removed from the later instances
* of IVersionedConfigUpgrade.
*/

public interface IVersionedConfigUpgrade 
{
	/**
	 * Upgrade a container configuration.
	 * @param container The container configuration to be upgraded.
	 * @param env The environment to perform the upgrade in, which
	 * includes a connection to the domain containing the configuration
	 * being upgraded.
	 * @return A message that can be displayed by the SUI for informational
	 * purposes. It can be null. This message should aggregate the
	 * messages of upgrades performed on the configuration for earlier
	 * releases.
	 * @throws Exception If there's a problem manipulating the configuration
	 * to perform the upgrade. The Exception message will be displayed
	 * by the SUI and logged in the error file.
	 * @see com.soncisw.mf.common.config.upgrade.UpgradeEnv
	 */
	public String upgradeMF_CONTAINER(IDirElement container, UpgradeEnv env) throws Exception;
	/**
	 * Upgrade an activation daemon configuration.
	 * @param daemon The AD configuration to be upgraded.
	 * @param env The environment to perform the upgrade in, which
	 * includes a connection to the domain containing the configuration
	 * being upgraded.
	 * @return A message that can be displayed by the SUI for informational
	 * purposes. It can be null. This message should aggregate the
	 * messages of upgrades performed on the configuration for earlier
	 * releases.
	 * @throws Exception If there's a problem manipulating the configuration
	 * to perform the upgrade. The Exception message will be displayed
	 * by the SUI and logged in the error file.
	 * @see com.soncisw.mf.common.config.upgrade.UpgradeEnv
	 */
	public String upgradeMF_ACTIVATION_DAEMON(IDirElement daemon, UpgradeEnv env) throws Exception;
	
	/**
	 * Upgrade a broker configuration.
	 * @param broker The broker configuration to be upgraded.
	 * @param env The environment to perform the upgrade in, which
	 * includes a connection to the domain containing the configuration
	 * being upgraded.
	 * @return A message that can be displayed by the SUI for informational
	 * purposes. It can be null. This message should aggregate the
	 * messages of upgrades performed on the configuration for earlier
	 * releases.
	 * @throws Exception If there's a problem manipulating the configuration
	 * to perform the upgrade. The Exception message will be displayed
	 * by the SUI and logged in the error file.
	 * @see com.soncisw.mf.common.config.upgrade.UpgradeEnv
	 */
	public String upgradeMQ_BROKER(IDirElement broker, UpgradeEnv env) throws Exception;
	
	/**
	 * Upgrade a cluster configuration.
	 * @param cluster The cluster configuration to be upgraded.
	 * @param env The environment to perform the upgrade in, which
	 * includes a connection to the domain containing the configuration
	 * being upgraded.
	 * @return A message that can be displayed by the SUI for informational
	 * purposes. It can be null. This message should aggregate the
	 * messages of upgrades performed on the configuration for earlier
	 * releases.
	 * @throws Exception If there's a problem manipulating the configuration
	 * to perform the upgrade. The Exception message will be displayed
	 * by the SUI and logged in the error file.
	 * @see com.soncisw.mf.common.config.upgrade.UpgradeEnv
	 */
	
	public String upgradeMQ_CLUSTER(IDirElement cluster, UpgradeEnv env) throws Exception;
	
	/**
	 * Upgrade a directory service configuration.
	 * @param dsElement The DS configuration to be upgraded.
	 * @param env The environment to perform the upgrade in, which
	 * includes a connection to the domain containing the configuration
	 * being upgraded.
	 * @return A message that can be displayed by the SUI for informational
	 * purposes. It can be null. This message should aggregate the
	 * messages of upgrades performed on the configuration for earlier
	 * releases.
	 * @throws Exception If there's a problem manipulating the configuration
	 * to perform the upgrade. The Exception message will be displayed
	 * by the SUI and logged in the error file.
	 * @see com.soncisw.mf.common.config.upgrade.UpgradeEnv
	 */
	public String upgradeMF_DIRECTORY_SERVICE(IDirElement dsElement, UpgradeEnv env) throws Exception;
	
	/**
	 * Upgrade a backup directory service configuration.
	 * @param backupElement The DS configuration to be upgraded.
	 * @param env The environment to perform the upgrade in, which
	 * includes a connection to the domain containing the configuration
	 * being upgraded.
	 * @return A message that can be displayed by the upgrade tool for informational
	 * purposes. It can be null. This message should aggregate the
	 * messages of upgrades performed on the configuration for earlier
	 * releases.
	 * @throws Exception If there's a problem manipulating the configuration
	 * to perform the upgrade. The Exception message will be displayed
	 * by the tool.
	 * @see com.soncisw.mf.common.config.upgrade.UpgradeEnv
	 */
	public String upgradeMF_BACKUP_DIRECTORY_SERVICE(IDirElement backupElement, UpgradeEnv env) throws Exception;
	
	/**
	 * Upgrade an agent manager configuration.
	 * @param agentManager The AM configuration to be upgraded.
	 * @param env The environment to perform the upgrade in, which
	 * includes a connection to the domain containing the configuration
	 * being upgraded.
	 * @return A message that can be displayed by the SUI for informational
	 * purposes. It can be null. This message should aggregate the
	 * messages of upgrades performed on the configuration for earlier
	 * releases.
	 * @throws Exception If there's a problem manipulating the configuration
	 * to perform the upgrade. The Exception message will be displayed
	 * by the SUI and logged in the error file.
	 * @see com.soncisw.mf.common.config.upgrade.UpgradeEnv
	 */
	public String upgradeMF_AGENT_MANAGER(IDirElement agentManager, UpgradeEnv env) throws Exception;
	
	/**
	 * Upgrade an ESB container configuration.
	 * @param xqContainer The ESB container configuration to be upgraded.
	 * @param env The environment to perform the upgrade in, which
	 * includes a connection to the domain containing the configuration
	 * being upgraded.
	 * @return A message that can be displayed by the SUI for informational
	 * purposes. It can be null. This message should aggregate the
	 * messages of upgrades performed on the configuration for earlier
	 * releases.
	 * @throws Exception If there's a problem manipulating the configuration
	 * to perform the upgrade. The Exception message will be displayed
	 * by the SUI and logged in the error file.
	 * @see com.soncisw.mf.common.config.upgrade.UpgradeEnv
	 */
	public String upgradeXQ_CONTAINER(IDirElement xqContainer, UpgradeEnv env) throws Exception;
	
	/**
	 * Upgrade a logger configuration.
	 * @param logger The logger configuration to be upgraded.
	 * @param env The environment to perform the upgrade in, which
	 * includes a connection to the domain containing the configuration
	 * being upgraded.
	 * @return A message that can be displayed by the SUI for informational
	 * purposes. It can be null. This message should aggregate the
	 * messages of upgrades performed on the configuration for earlier
	 * releases.
	 * @throws Exception If there's a problem manipulating the configuration
	 * to perform the upgrade. The Exception message will be displayed
	 * by the SUI and logged in the error file.
	 * @see com.soncisw.mf.common.config.upgrade.UpgradeEnv
	 */
	
	public String upgradeMF_LOGGER(IDirElement logger, UpgradeEnv env) throws Exception;
	
	/**
	 * Upgrade a collection monitor configuration.
	 * @param monitor The collection monitor configuration to be upgraded.
	 * @param env The environment to perform the upgrade in, which
	 * includes a connection to the domain containing the configuration
	 * being upgraded.
	 * @return A message that can be displayed by the SUI for informational
	 * purposes. It can be null. This message should aggregate the
	 * messages of upgrades performed on the configuration for earlier
	 * releases.
	 * @throws Exception If there's a problem manipulating the configuration
	 * to perform the upgrade. The Exception message will be displayed
	 * by the SUI and logged in the error file.
	 * @see com.soncisw.mf.common.config.upgrade.UpgradeEnv
	 */
	public String upgradeMF_COLLECTION_MONITOR(IDirElement monitor, UpgradeEnv env) throws Exception;

    /**
     * Upgrade a hostmanager configuration.
     * @param hostmanager The hostmanager configuration to be upgraded.
     * @param env The environment to perform the upgrade in, which
     * includes a connection to the domain containing the configuration
     * being upgraded.
     * @return A message that can be displayed by the SUI for informational
     * purposes. It can be null. This message should aggregate the
     * messages of upgrades performed on the configuration for earlier
     * releases.
     * @throws Exception If there's a problem manipulating the configuration
     * to perform the upgrade. The Exception message will be displayed
     * by the SUI and logged in the error file.
     * @see com.soncisw.mf.common.config.upgrade.UpgradeEnv
     */

    public String upgradeMF_HOST_MANAGER(IDirElement hostmanager, UpgradeEnv env) throws Exception;
	/**
	 * Generic configuration upgrade. This method will get called
	 * for configurations in the DS of types which do not have their
	 * own upgrade method. Can't think of any right now, though this
	 * method has been used in the past before a configuration type 
	 * was granted its own upgrade method.
	 * @param el The configuration to be upgraded.
	 * @param env The environment to perform the upgrade in, which
	 * includes a connection to the domain containing the configuration
	 * being upgraded.
	 * @return A message that can be displayed by the SUI for informational
	 * purposes. It can be null. This message should aggregate the
	 * messages of upgrades performed on the configuration for earlier
	 * releases.
	 * @throws Exception If there's a problem manipulating the configuration
	 * to perform the upgrade. The Exception message will be displayed
	 * by the SUI and logged in the error file.
	 * @see com.soncisw.mf.common.config.upgrade.UpgradeEnv
	 */
	public String basicConfigUpgrade(IDirElement el, UpgradeEnv env) throws Exception; 
	
	/**
	 * Return the followup version of the configuration after it's been 
	 * upgraded by this object. For instance, if this object upgrades a 
	 * configuration of version "101", this method would return "102"
	 * @return The release version of the configuration after its been upgraded.
	 */
	public String getUpgradedReleaseVersion();

}
