package com.sonicsw.mf.common.config.upgrade;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Date;

public class ShortcutCreator 
{
	/*
	 * 
	 */
	
	private boolean m_debug = false;
	public ShortcutCreator(boolean debug)
	{
		m_debug = debug;
	}
	
	public boolean createShortcut(String sourceFilePath, String destinationDirPath,
			String shortcutName, String iconFilePath, boolean overwriteExisting)
	
	    throws ShortcutCreatorException 
	{

		traceln("createShortcut(\""
				+ sourceFilePath + "\", \""
				+ destinationDirPath + "\", "
				+ (iconFilePath == null ? "[icon unspecified]" : iconFilePath) + "\", "
				+ (overwriteExisting ? "true" : "false") + ")");
		
		if ("".equals(sourceFilePath) || "".equals(destinationDirPath)) 
		{
			throw new ShortcutCreatorException(sourceFilePath, destinationDirPath,
				"Empty file name.");
	    }

		// process the shortcut source
		
		File sourceFile = new File(sourceFilePath);

		// make sure the source is a file
		if (!sourceFile.isFile()) 
		{
			throw new ShortcutCreatorException(sourceFilePath, destinationDirPath,
				"The target for the shortcut is not a valid file.");
		}

		// process the icon
		
		File iconFile = null;
		
		if (iconFilePath == null) 
		{
		
			// no path to an icon was provided: we will
			// use the icon from the file pointed by the shortcut
			
			iconFile = sourceFile;
			
		} 
		else 
		{
		
			iconFile = new File(iconFilePath);
	
			// make sure the icon is a file
			if (!iconFile.exists()) 
			{
				iconFile = null;
			}
		}
		
		File destinationDir = new File(destinationDirPath);

		// create the destination directory in case it does not exist
		if (!destinationDir.exists()) 
		{
			destinationDir.mkdirs();
		}
		
		return createShortcut(sourceFile, destinationDir, shortcutName, iconFile, overwriteExisting);
	}

	private boolean createShortcut(File sourceFile, File destinationDir, String shortcutName,
			File iconFile,  boolean overwriteExisting)
	
	    throws ShortcutCreatorException 
	    {
		
		// Create an Internet Shortcut file with the following form:
	    //   [InternetShortcut]
	    //   URL=file://C:/path/to/executable.exe
	    //   IconIndex=0
	    //   IconFile=C:\path\to\[executable.exe|icon.ico]

		URI sourceFileURI = sourceFile.toURI();

		// set or construct the file name for the shortcut 
		
		String internetShortcutFileName = shortcutName == null ? null : shortcutName + ".url";

		if (internetShortcutFileName == null) 
		{
			String sourceFileName = sourceFile.getName();
			internetShortcutFileName = sourceFileName.substring(0, sourceFileName.length() - 4) + ".url";
		}
		
		// unless the "overwrite existing" option is used, make sure that the file does not already exist
		
		File internetShortcutFile = new File(destinationDir, internetShortcutFileName);
		if (!overwriteExisting && internetShortcutFile.exists()) 
		{
			throw new ShortcutCreatorException(sourceFile.getAbsolutePath(), destinationDir.getAbsolutePath(),
	    		"The file already exists.");
		}
		
		// write the shortcut
		
		PrintWriter out = null;
		try 
		{
			out = new PrintWriter(internetShortcutFile);
		} 
		catch (FileNotFoundException e) 
		{
			throw new ShortcutCreatorException(sourceFile.getAbsolutePath(), destinationDir.getAbsolutePath(),
    		    "Error when writing the shortcut: " + e.getMessage());
		}
   	    
   	    out.println("[InternetShortcut]");
   	    out.println("URL=" + sourceFileURI.toString());
   	    out.println("IconIndex=0");
   	    out.println("IconFile=" + iconFile.getAbsolutePath());
   	    
   	    out.close();

		traceln("createShortcut(File, File, File, boolean): DONE");

		return true;
	}

	private String getTimeStamp() 
	{
		Date now = new Date(System.currentTimeMillis());
		return now.toString();
	}

	private String getTrace(String trace) 
	{
		String thisClassShortName = "ShortcutCreator";
		return getTimeStamp() + ": " + thisClassShortName + ": "+ trace;
	}
	
	private void traceln(String trace) 
	{
		if (m_debug) 
		{
			System.out.println(getTrace(trace));
		}
	}

}
