package com.sonicsw.mf.common.config.upgrade;

public class ShortcutCreatorException extends Exception
{
	String sourceFilePath;
	String destinationDirPath;
	String errorMessage;
	
	ShortcutCreatorException(String sourceFilePath, String destinationDirPath, String errorMessage) 
	{
		this.sourceFilePath = sourceFilePath;
		this.destinationDirPath =  destinationDirPath;
		this.errorMessage = errorMessage;
	}

	ShortcutCreatorException(String sourceFilePath, String destinationDirPath, String errorMessage, Throwable cause) 
	{
	    super(cause);
	    this.sourceFilePath = sourceFilePath;
	    this.destinationDirPath =  destinationDirPath;
	    this.errorMessage = errorMessage;
	}

	@Override
	public String getMessage() 
	{
		return "Could not create shortcut for file: \"" + sourceFilePath
		    + "\" in destination directory: \"" + destinationDirPath
		    + "\". Cause: " + errorMessage + "";
	}
}
