package com.sonicsw.mf.common.config.upgrade;

import java.util.HashMap;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.dirconfig.IDirElement;

public class TypedConfigUpgrade75 implements IVersionedConfigUpgrade
{
	
	HashMap m_nodeNames = new HashMap();
	UpgradeEnv m_upgradeEnv = null;
	
	@Override
    public String getUpgradedReleaseVersion()
	{
		return "103";
	}
	
	@Override
    public String upgradeMF_CONTAINER(IDirElement container, UpgradeEnv env)
	    throws Exception
	{
		return null;
	}
	
	@Override
    public String upgradeMQ_BROKER(IDirElement broker, UpgradeEnv env) throws Exception
	{
		m_upgradeEnv = env;
		saveRoutingNodeName(broker.getAttributes());
		return null;
	}
	
	@Override
    public String upgradeMQ_CLUSTER(IDirElement cluster, UpgradeEnv env)
	    throws Exception
	{
		m_upgradeEnv = env;
		String clusterID = cluster.getIdentity().getName();
        IAttributeSet topSet = cluster.getAttributes();
        String nodeName = (String)m_nodeNames.get(clusterID);
        if (nodeName != null)
        {
            // maybe there were no brokers in the cluster
            topSet.setStringAttribute("ROUTING_NODE_NAME", nodeName);
        }
        else
        	// use the cluster name as the node name
        {
        	String clusterName = (String)topSet.getAttribute("CLUSTER_NAME");
        	topSet.setStringAttribute("ROUTING_NODE_NAME", clusterName);
        }
        return null;
	}
	
	@Override
    public String upgradeMF_ACTIVATION_DAEMON(IDirElement daemon, UpgradeEnv env)
    throws Exception
    {
		return null;
    }
	
	@Override
    public String upgradeMF_DIRECTORY_SERVICE(IDirElement DS, UpgradeEnv env) throws Exception
	{
		return null;
	}
	
	@Override
    public String upgradeMF_BACKUP_DIRECTORY_SERVICE(IDirElement DS, UpgradeEnv env) throws Exception
	{
		return null;
	}
	
	@Override
    public String upgradeMF_AGENT_MANAGER(IDirElement AM, UpgradeEnv env) throws Exception
	{
		return null;
	}
	
    //If this is the first broker in a cluster being upgraded, remember its routing
    // node name to set it on the broker
    private void saveRoutingNodeName(IAttributeSet topSet)
    {
    	String clusterName = null;
    	// is this broker in a cluster
    	IAttributeSet refs = (IAttributeSet)topSet.getAttribute("CONFIG_ELEMENT_REFERENCES");
    	if (refs != null)
    	{
    		Reference clusterRef = (Reference)refs.getAttribute("CLUSTER_CONFIG_ELEMENT_REF");
    		if (clusterRef != null)
            {
                clusterName = clusterRef.getElementName();
            }
    	}
    	// have we already seen this cluster?
    	if (clusterName != null && m_nodeNames.get(clusterName) == null)
    	{
    	    IAttributeSet routingAttrs = (IAttributeSet)topSet.getAttribute("BROKER_ROUTING_PARAMETERS");
            //assume routingAttrs is not null; ROUTING_NODE_NAME is required
    	    String nodeName = (String)routingAttrs.getAttribute("ROUTING_NODE_NAME");
    	    m_nodeNames.put(clusterName, nodeName);
    	}
    }
    
    @Override
    public String upgradeXQ_CONTAINER(IDirElement xqContainer, UpgradeEnv env) throws Exception
    {
    	return null;
    }
	@Override
    public String upgradeMF_LOGGER(IDirElement logger, UpgradeEnv env) throws Exception
	{
		return null;
	}
	@Override
    public String upgradeMF_COLLECTION_MONITOR(IDirElement monitor, UpgradeEnv env) throws Exception
	{
		return null;
	}

    @Override
    public String upgradeMF_HOST_MANAGER(IDirElement hostmanager, UpgradeEnv env) throws Exception
    {
        return null;
    }

    @Override
    public String basicConfigUpgrade(IDirElement el, UpgradeEnv env) throws Exception
	{
		return null;
	}
}
